/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ConsentWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    private static final String VIEW_ID_CONSENT_VIEW = "casConsentView";
    private static final String STATE_ID_CONSENT_CONFIRM = "confirmAttributeConsent";
    private static final String ACTION_GEN_SERVICE_TICKET_AFTER_CONSENT = "generateServiceTicketAfterConsent";

    public ConsentWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            this.createInitialConsentEnabledAction(flow);
            this.createConsentRequiredCheckAction(flow);
            this.createConsentTransitions(flow);
            this.createConsentView(flow);
        }
    }

    private void createInitialConsentEnabledAction(Flow flow) {
        flow.getStartActionList().add(new Action(){

            public Event execute(RequestContext requestContext) {
                return new EventFactorySupport().success((Object)this);
            }
        });
    }

    private void createConsentView(Flow flow) {
        ViewState state = this.createViewState(flow, VIEW_ID_CONSENT_VIEW, VIEW_ID_CONSENT_VIEW);
        this.createTransitionForState((TransitionableState)state, "confirm", STATE_ID_CONSENT_CONFIRM);
        this.createTransitionForState((TransitionableState)state, "cancel", "initializeLoginForm");
        ActionState action = this.createActionState(flow, STATE_ID_CONSENT_CONFIRM, (Action)this.createEvaluateAction("confirmConsentAction"));
        this.createTransitionForState((TransitionableState)action, "success", ACTION_GEN_SERVICE_TICKET_AFTER_CONSENT);
    }

    private void createConsentTransitions(Flow flow) {
        ActionState sendTicket = (ActionState)this.getState(flow, "generateServiceTicket", ActionState.class);
        this.createTransitionForState((TransitionableState)sendTicket, "consentRequired", VIEW_ID_CONSENT_VIEW);
    }

    private void createConsentRequiredCheckAction(Flow flow) {
        this.createEvaluateActionForExistingActionState(flow, "generateServiceTicket", "checkConsentRequiredAction");
        this.createClonedActionState(flow, ACTION_GEN_SERVICE_TICKET_AFTER_CONSENT, "generateServiceTicket");
    }
}

