/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo;

import java.util.Optional;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.adaptors.duo.config.DuoSecurityAuthenticationEventExecutionPlanConfiguration;
import org.apereo.cas.adaptors.duo.config.DuoSecurityComponentSerializationConfiguration;
import org.apereo.cas.adaptors.duo.config.DuoSecurityConfiguration;
import org.apereo.cas.adaptors.duo.config.DuoSecurityMultifactorProviderBypassConfiguration;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.mfa.TestMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationServiceSelectionStrategyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationSupportConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreMultifactorAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasDefaultServiceTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasPersonDirectoryTestConfiguration;
import org.apereo.cas.config.support.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.apereo.cas.services.web.config.CasThemesConfiguration;
import org.apereo.cas.trusted.config.MultifactorAuthnTrustConfiguration;
import org.apereo.cas.trusted.config.MultifactorAuthnTrustWebflowConfiguration;
import org.apereo.cas.trusted.config.MultifactorAuthnTrustedDeviceFingerprintConfiguration;
import org.apereo.cas.web.config.CasCookieConfiguration;
import org.apereo.cas.web.flow.config.CasCoreWebflowConfiguration;
import org.apereo.cas.web.flow.config.CasMultifactorAuthenticationWebflowConfiguration;
import org.apereo.cas.web.flow.config.CasWebflowContextConfiguration;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.mockito.Mockito;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.support.LiteralExpression;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Import;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.engine.support.DefaultTargetStateResolver;
import org.springframework.webflow.engine.support.DefaultTransitionCriteria;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

public abstract class BaseDuoSecurityTests {
    public static RequestContext getMockRequestContext(ConfigurableApplicationContext applicationContext) {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRemoteAddr("185.86.151.11");
        request.setLocalAddr("195.88.151.11");
        request.addHeader("user-agent", (Object)"MSIE");
        ClientInfoHolder.setClientInfo((ClientInfo)new ClientInfo((HttpServletRequest)request));
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        MultifactorAuthenticationProvider provider = BaseDuoSecurityTests.getDuoSecurityMultifactorAuthenticationProvider();
        TestMultifactorAuthenticationProvider.registerProviderIntoApplicationContext((ConfigurableApplicationContext)applicationContext, (MultifactorAuthenticationProvider)provider);
        DefaultTargetStateResolver targetResolver = new DefaultTargetStateResolver(provider.getId());
        Transition transition = new Transition((TransitionCriteria)new DefaultTransitionCriteria((Expression)new LiteralExpression(provider.getId())), (TargetStateResolver)targetResolver);
        context.getRootFlow().getGlobalTransitionSet().add(transition);
        WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)CoreAuthenticationTestUtils.getWebApplicationService());
        Authentication authentication = CoreAuthenticationTestUtils.getAuthentication();
        WebUtils.putAuthentication((Authentication)authentication, (RequestContext)context);
        AuthenticationResultBuilder builder = (AuthenticationResultBuilder)Mockito.mock(AuthenticationResultBuilder.class);
        Mockito.when((Object)builder.getInitialAuthentication()).thenReturn(Optional.of(authentication));
        Mockito.when((Object)builder.collect((Authentication)Mockito.any(Authentication.class))).thenReturn((Object)builder);
        WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)builder, (RequestContext)context);
        return context;
    }

    public static MultifactorAuthenticationProvider getDuoSecurityMultifactorAuthenticationProvider() {
        TestMultifactorAuthenticationProvider provider = new TestMultifactorAuthenticationProvider();
        provider.setId("mfa-duo");
        return provider;
    }

    @ImportAutoConfiguration(value={RefreshAutoConfiguration.class, MailSenderAutoConfiguration.class, AopAutoConfiguration.class})
    @SpringBootConfiguration
    @Import(value={MultifactorAuthnTrustConfiguration.class, MultifactorAuthnTrustedDeviceFingerprintConfiguration.class, MultifactorAuthnTrustWebflowConfiguration.class, DuoSecurityAuthenticationEventExecutionPlanConfiguration.class, DuoSecurityComponentSerializationConfiguration.class, DuoSecurityMultifactorProviderBypassConfiguration.class, DuoSecurityConfiguration.class, CasCoreNotificationsConfiguration.class, CasCoreServicesConfiguration.class, CasWebflowContextConfiguration.class, CasCoreHttpConfiguration.class, CasThemesConfiguration.class, CasCoreAuthenticationConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreLogoutConfiguration.class, CasCoreMultifactorAuthenticationConfiguration.class, CasMultifactorAuthenticationWebflowConfiguration.class, CasCoreAuthenticationServiceSelectionStrategyConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, CasCoreWebflowConfiguration.class, CasCoreConfiguration.class, CasPersonDirectoryTestConfiguration.class, CasCoreAuthenticationSupportConfiguration.class, CasCookieConfiguration.class, CasCoreUtilConfiguration.class, CasCoreWebConfiguration.class, CasCoreTicketCatalogConfiguration.class, CasDefaultServiceTicketIdGeneratorsConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class})
    public static class SharedTestConfiguration {
    }
}

