/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.authn;

import org.apereo.cas.BaseCasWebflowMultifactorAuthenticationTests;
import org.apereo.cas.adaptors.duo.BaseDuoSecurityTests;
import org.apereo.cas.adaptors.duo.authn.BasicDuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.duo.authn.UniversalPromptDuoSecurityAuthenticationService;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderFactoryBean;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.BaseMultifactorProviderProperties;
import org.apereo.cas.configuration.model.support.mfa.DuoSecurityMultifactorProperties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;

@Tag(value="MFA")
@SpringBootTest(classes={BaseDuoSecurityTests.SharedTestConfiguration.class}, properties={"cas.authn.mfa.duo[0].duo-secret-key=Q2IU2i8BFNd6VYflZT8Evl6lF7oPlj3PM15BmRU7", "cas.authn.mfa.duo[0].duo-application-key=abcdefghijklmnop", "cas.authn.mfa.duo[0].duo-integration-key=DIOXVRZD2UMZ8XXMNFQ5", "cas.authn.mfa.duo[0].duo-api-host=theapi.duosecurity.com"})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class DuoSecurityMultifactorAuthenticationProviderFactoryTests
extends BaseCasWebflowMultifactorAuthenticationTests {
    @Autowired
    @Qualifier(value="duoProviderFactory")
    private MultifactorAuthenticationProviderFactoryBean<DuoSecurityMultifactorAuthenticationProvider, DuoSecurityMultifactorProperties> duoProviderFactory;

    @Test
    public void verifyBasicProvider() {
        DuoSecurityMultifactorProperties props = (DuoSecurityMultifactorProperties)this.casProperties.getAuthn().getMfa().getDuo().get(0);
        props.setDuoApplicationKey("abcdefghijklmnop");
        DuoSecurityMultifactorAuthenticationProvider provider = (DuoSecurityMultifactorAuthenticationProvider)this.duoProviderFactory.createProvider((BaseMultifactorProviderProperties)props);
        Assertions.assertTrue((boolean)(provider.getDuoAuthenticationService() instanceof BasicDuoSecurityAuthenticationService));
    }

    @Test
    public void verifyUniversalProvider() {
        DuoSecurityMultifactorProperties props = (DuoSecurityMultifactorProperties)this.casProperties.getAuthn().getMfa().getDuo().get(0);
        props.setDuoApplicationKey(null);
        DuoSecurityMultifactorAuthenticationProvider provider = (DuoSecurityMultifactorAuthenticationProvider)this.duoProviderFactory.createProvider((BaseMultifactorProviderProperties)props);
        Assertions.assertTrue((boolean)(provider.getDuoAuthenticationService() instanceof UniversalPromptDuoSecurityAuthenticationService));
    }
}

