/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.authn;

import com.duosecurity.Client;
import com.duosecurity.model.AccessDevice;
import com.duosecurity.model.Application;
import com.duosecurity.model.AuthContext;
import com.duosecurity.model.AuthDevice;
import com.duosecurity.model.AuthResult;
import com.duosecurity.model.HealthCheckResponse;
import com.duosecurity.model.Location;
import com.duosecurity.model.Token;
import com.duosecurity.model.User;
import java.util.UUID;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationResult;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityUniversalPromptCredential;
import org.apereo.cas.adaptors.duo.authn.UniversalPromptDuoSecurityAuthenticationService;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.DuoSecurityMultifactorProperties;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.util.http.HttpClient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@Tag(value="MFA")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class UniversalPromptDuoSecurityAuthenticationServiceTests {
    @Test
    public void verifyPingFails() throws Exception {
        Client duoClient = (Client)Mockito.mock(Client.class);
        Mockito.when((Object)duoClient.healthCheck()).thenThrow(new Throwable[]{new RuntimeException()});
        DuoSecurityMultifactorProperties duoProperties = new DuoSecurityMultifactorProperties();
        UniversalPromptDuoSecurityAuthenticationService service = new UniversalPromptDuoSecurityAuthenticationService(duoProperties, (HttpClient)Mockito.mock(HttpClient.class), duoClient);
        Assertions.assertTrue((boolean)service.getDuoClient().isPresent());
        Assertions.assertFalse((boolean)service.ping());
    }

    @Test
    public void verifyPing() throws Exception {
        Client duoClient = (Client)Mockito.mock(Client.class);
        Mockito.when((Object)duoClient.healthCheck()).thenReturn((Object)new HealthCheckResponse());
        DuoSecurityMultifactorProperties duoProperties = new DuoSecurityMultifactorProperties();
        UniversalPromptDuoSecurityAuthenticationService service = new UniversalPromptDuoSecurityAuthenticationService(duoProperties, (HttpClient)Mockito.mock(HttpClient.class), duoClient);
        Assertions.assertTrue((boolean)service.getDuoClient().isPresent());
        Assertions.assertTrue((boolean)service.ping());
    }

    @Test
    public void verifyAuth() throws Exception {
        String state = UUID.randomUUID().toString();
        DuoSecurityUniversalPromptCredential credential = new DuoSecurityUniversalPromptCredential(state, RegisteredServiceTestUtils.getAuthentication((String)"casuser"));
        Client duoClient = (Client)Mockito.mock(Client.class);
        Token token = new Token();
        token.setAud("aud");
        token.setIat(Double.valueOf(123456.0));
        token.setExp(Integer.valueOf(123456));
        token.setAuth_time(Integer.valueOf(123456789));
        token.setIss("issuer");
        token.setSub("casuser");
        token.setPreferred_username("CAS");
        AuthContext authContext = new AuthContext();
        AccessDevice accessDevice = new AccessDevice();
        accessDevice.setLocation(new Location());
        accessDevice.setHostname("hostname");
        authContext.setAccess_device(accessDevice);
        AuthDevice authDevice = new AuthDevice();
        authDevice.setLocation(new Location());
        authContext.setAuth_device(authDevice);
        authContext.setUser(new User());
        authContext.setApplication(new Application());
        token.setAuth_context(authContext);
        token.setAuth_result(new AuthResult());
        Mockito.when((Object)duoClient.exchangeAuthorizationCodeFor2FAResult(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)token);
        DuoSecurityMultifactorProperties duoProperties = new DuoSecurityMultifactorProperties();
        UniversalPromptDuoSecurityAuthenticationService service = new UniversalPromptDuoSecurityAuthenticationService(duoProperties, (HttpClient)Mockito.mock(HttpClient.class), duoClient);
        DuoSecurityAuthenticationResult result = service.authenticate((Credential)credential);
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isSuccess());
        Assertions.assertEquals((Object)"CAS", (Object)result.getUsername());
        Assertions.assertNotNull((Object)result.getAttributes());
    }
}

