/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web.flow;

import org.apereo.cas.adaptors.duo.BaseDuoSecurityTests;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.BaseMultifactorWebflowConfigurerTests;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.ViewState;

@SpringBootTest(classes={BaseDuoSecurityTests.SharedTestConfiguration.class}, properties={"cas.authn.mfa.duo[0].duo-secret-key=Q2IU2i8BFNd6VYflZT8Evl6lF7oPlj3PM15BmRU7", "cas.authn.mfa.duo[0].duo-integration-key=DIOXVRZD2UMZ8XXMNFQ5", "cas.authn.mfa.duo[0].trusted-device-enabled=true", "cas.authn.mfa.duo[0].duo-api-host=theapi.duosecurity.com"})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Tag(value="WebflowConfig")
public class DuoSecurityUniversalPromptMultifactorWebflowConfigurerTests
extends BaseMultifactorWebflowConfigurerTests {
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    @Test
    public void verifyUniversalPromptFlow() {
        Flow loginFlow = (Flow)this.loginFlowDefinitionRegistry.getFlowDefinition("login");
        Assertions.assertNotNull((Object)loginFlow.getState("duoUniversalPromptPrepareValidate"));
        Assertions.assertEquals((Object)"duoUniversalPromptPrepareValidate", (Object)loginFlow.getStartState().getId());
        FlowDefinitionRegistry registry = this.getMultifactorFlowDefinitionRegistry();
        Flow flow = (Flow)registry.getFlowDefinition(this.getMultifactorEventId());
        ViewState viewState = (ViewState)flow.getState("viewLoginFormDuo");
        Assertions.assertTrue((boolean)viewState.getEntryActionList().get(0).toString().contains("duoUniversalPromptPrepareLoginAction"));
    }

    protected FlowDefinitionRegistry getMultifactorFlowDefinitionRegistry() {
        return (FlowDefinitionRegistry)this.applicationContext.getBean("mfa-duo", FlowDefinitionRegistry.class);
    }

    protected String getMultifactorEventId() {
        return "mfa-duo";
    }
}

