/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web.flow.action;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccount;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccountStatus;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.duo.web.flow.action.DuoSecurityDetermineUserAccountAction;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.mfa.TestMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.util.MockServletContext;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

@Tag(value="WebflowMfaActions")
public class DuoSecurityDetermineUserAccountActionTests {
    private static void verifyOperation(DuoSecurityUserAccountStatus status, String eventId) {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)CoreAuthenticationTestUtils.getWebApplicationService());
        Authentication authentication = CoreAuthenticationTestUtils.getAuthentication();
        WebUtils.putAuthentication((Authentication)authentication, (RequestContext)context);
        DuoSecurityUserAccount account = new DuoSecurityUserAccount(authentication.getPrincipal().getId());
        account.setStatus(status);
        account.setEnrollPortalUrl("https://example.org");
        DuoSecurityAuthenticationService duoService = (DuoSecurityAuthenticationService)Mockito.mock(DuoSecurityAuthenticationService.class);
        Mockito.when((Object)duoService.getUserAccount(Mockito.anyString())).thenReturn((Object)account);
        DuoSecurityMultifactorAuthenticationProvider provider = (DuoSecurityMultifactorAuthenticationProvider)Mockito.mock(DuoSecurityMultifactorAuthenticationProvider.class);
        Mockito.when((Object)provider.getId()).thenReturn((Object)"mfa-duo");
        Mockito.when((Object)provider.getDuoAuthenticationService()).thenReturn((Object)duoService);
        Mockito.when((Object)provider.getRegistrationUrl()).thenReturn((Object)"https://registration.duo.com");
        Mockito.when((Object)provider.matches(Mockito.anyString())).thenReturn((Object)Boolean.TRUE);
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        WebUtils.putMultifactorAuthenticationProviderIdIntoFlowScope((RequestContext)context, (MultifactorAuthenticationProvider)provider);
        TestMultifactorAuthenticationProvider.registerProviderIntoApplicationContext((ConfigurableApplicationContext)applicationContext, (MultifactorAuthenticationProvider)provider);
        DuoSecurityDetermineUserAccountAction action = new DuoSecurityDetermineUserAccountAction((ApplicationContext)applicationContext);
        Event event = action.execute((RequestContext)context);
        Assertions.assertEquals((Object)eventId, (Object)event.getId());
    }

    @Test
    public void verifyOperationEnroll() {
        DuoSecurityDetermineUserAccountActionTests.verifyOperation(DuoSecurityUserAccountStatus.ENROLL, "enroll");
    }

    @Test
    public void verifyOperationAllow() {
        DuoSecurityDetermineUserAccountActionTests.verifyOperation(DuoSecurityUserAccountStatus.ALLOW, "bypass");
    }

    @Test
    public void verifyOperationDeny() {
        DuoSecurityDetermineUserAccountActionTests.verifyOperation(DuoSecurityUserAccountStatus.DENY, "deny");
    }

    @Test
    public void verifyOperationUnavailable() {
        DuoSecurityDetermineUserAccountActionTests.verifyOperation(DuoSecurityUserAccountStatus.UNAVAILABLE, "unavailable");
    }

    @Test
    public void verifyOperationAuth() {
        DuoSecurityDetermineUserAccountActionTests.verifyOperation(DuoSecurityUserAccountStatus.AUTH, "success");
    }
}

