/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web.flow.action;

import org.apereo.cas.BaseCasWebflowMultifactorAuthenticationTests;
import org.apereo.cas.adaptors.duo.BaseDuoSecurityTests;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@SpringBootTest(classes={BaseDuoSecurityTests.SharedTestConfiguration.class}, properties={"cas.authn.mfa.duo[0].duo-secret-key=1234567890", "cas.authn.mfa.duo[0].duo-application-key=abcdefghijklmnop", "cas.authn.mfa.duo[0].duo-integration-key=QRSTUVWXYZ", "cas.authn.mfa.duo[0].duo-api-host=theapi.duosecurity.com"})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Tag(value="WebflowMfaActions")
public class DuoSecurityDirectAuthenticationActionTests
extends BaseCasWebflowMultifactorAuthenticationTests {
    @Autowired
    @Qualifier(value="duoNonWebAuthenticationAction")
    private Action duoNonWebAuthenticationAction;
    private RequestContext context;

    @BeforeEach
    public void setup() {
        this.context = BaseDuoSecurityTests.getMockRequestContext(this.applicationContext);
    }

    @Test
    public void verifyOperation() throws Exception {
        MultifactorAuthenticationProvider provider = BaseDuoSecurityTests.getDuoSecurityMultifactorAuthenticationProvider();
        WebUtils.putMultifactorAuthenticationProviderIdIntoFlowScope((RequestContext)this.context, (MultifactorAuthenticationProvider)provider);
        Event event = this.duoNonWebAuthenticationAction.execute(this.context);
        Assertions.assertEquals((Object)"success", (Object)event.getId());
    }
}

