/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web.flow.action;

import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityCredential;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.duo.web.flow.action.DuoSecurityPrepareWebLoginFormAction;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.mfa.TestMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.util.MockServletContext;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionContext;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ViewFactory;
import org.springframework.webflow.test.MockFlowExecutionContext;
import org.springframework.webflow.test.MockFlowSession;
import org.springframework.webflow.test.MockRequestContext;

@Tag(value="WebflowMfaActions")
public class DuoSecurityPrepareWebLoginFormActionTests {
    @Test
    public void verifyOperation() throws Exception {
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        MockFlowSession flowSession = new MockFlowSession(new Flow("login"));
        flowSession.setState((State)new ViewState(flowSession.getDefinitionInternal(), "viewState", (ViewFactory)Mockito.mock(ViewFactory.class)));
        MockFlowExecutionContext exec = new MockFlowExecutionContext((FlowSession)flowSession);
        MockRequestContext context = new MockRequestContext((FlowExecutionContext)exec);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)CoreAuthenticationTestUtils.getWebApplicationService());
        Authentication authentication = CoreAuthenticationTestUtils.getAuthentication();
        WebUtils.putAuthentication((Authentication)authentication, (RequestContext)context);
        DuoSecurityAuthenticationService duoService = (DuoSecurityAuthenticationService)Mockito.mock(DuoSecurityAuthenticationService.class);
        DuoSecurityMultifactorAuthenticationProvider provider = (DuoSecurityMultifactorAuthenticationProvider)Mockito.mock(DuoSecurityMultifactorAuthenticationProvider.class);
        Mockito.when((Object)provider.getId()).thenReturn((Object)"mfa-duo");
        Mockito.when((Object)provider.getDuoAuthenticationService()).thenReturn((Object)duoService);
        Mockito.when((Object)provider.matches(Mockito.anyString())).thenReturn((Object)Boolean.TRUE);
        WebUtils.putCredential((RequestContext)context, (Credential)new DuoSecurityCredential(authentication.getPrincipal().getId(), UUID.randomUUID().toString(), provider.getId()));
        WebUtils.putMultifactorAuthenticationProviderIdIntoFlowScope((RequestContext)context, (MultifactorAuthenticationProvider)provider);
        TestMultifactorAuthenticationProvider.registerProviderIntoApplicationContext((ConfigurableApplicationContext)applicationContext, (MultifactorAuthenticationProvider)provider);
        DuoSecurityPrepareWebLoginFormAction action = new DuoSecurityPrepareWebLoginFormAction((ApplicationContext)applicationContext);
        Event event = action.execute((RequestContext)context);
        Assertions.assertEquals((Object)"success", (Object)event.getId());
    }
}

