/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web.flow.action;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.BaseCasWebflowMultifactorAuthenticationTests;
import org.apereo.cas.adaptors.duo.BaseDuoSecurityTests;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.mfa.TestMultifactorAuthenticationProvider;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.DuoSecurityMultifactorProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.test.MockRequestContext;

@SpringBootTest(classes={BaseDuoSecurityTests.SharedTestConfiguration.class}, properties={"cas.authn.mfa.duo[0].duo-secret-key=Q2IU2i8BFNd6VYflZT8Evl6lF7oPlj3PM15BmRU7", "cas.authn.mfa.duo[0].mode=UNIVERSAL", "cas.authn.mfa.duo[0].duo-integration-key=DIOXVRZD2UMZ8XXMNFQ5", "cas.authn.mfa.duo[0].trusted-device-enabled=true", "cas.authn.mfa.duo[0].duo-api-host=theapi.duosecurity.com"})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Tag(value="WebflowMfaActions")
public class DuoSecurityUniversalPromptPrepareLoginActionTests
extends BaseCasWebflowMultifactorAuthenticationTests {
    @Autowired
    @Qualifier(value="duoUniversalPromptPrepareLoginAction")
    private Action duoUniversalPromptPrepareLoginAction;

    @Test
    public void verifyOperation() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        String identifier = ((DuoSecurityMultifactorProperties)this.casProperties.getAuthn().getMfa().getDuo().get(0)).getId();
        MultifactorAuthenticationProvider provider = TestMultifactorAuthenticationProvider.registerProviderIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext, (MultifactorAuthenticationProvider)new TestMultifactorAuthenticationProvider(identifier));
        WebUtils.putAuthentication((Authentication)RegisteredServiceTestUtils.getAuthentication(), (RequestContext)context);
        WebUtils.putRegisteredService((RequestContext)context, (RegisteredService)RegisteredServiceTestUtils.getRegisteredService());
        WebUtils.putMultifactorAuthenticationProviderIdIntoFlowScope((RequestContext)context, (MultifactorAuthenticationProvider)provider);
        Event result = this.duoUniversalPromptPrepareLoginAction.execute((RequestContext)context);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)result.getAttributes().get("result"));
        Assertions.assertTrue((boolean)context.getFlowScope().contains("duoUniversalPromptLoginUrl"));
    }
}

