/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web.flow.action;

import com.duosecurity.Client;
import com.duosecurity.model.Token;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.BaseCasWebflowMultifactorAuthenticationTests;
import org.apereo.cas.adaptors.duo.BaseDuoSecurityTests;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationResult;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderBean;
import org.apereo.cas.authentication.mfa.TestMultifactorAuthenticationProvider;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.DuoSecurityMultifactorProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.test.MockRequestContext;

@SpringBootTest(classes={DuoSecurityUniversalPromptValidateLoginActionTestConfiguration.class, BaseDuoSecurityTests.SharedTestConfiguration.class}, properties={"cas.authn.mfa.duo[0].duo-secret-key=Q2IU2i8BFNd6VYflZT8Evl6lF7oPlj3PM15BmRU7", "cas.authn.mfa.duo[0].mode=UNIVERSAL", "cas.authn.mfa.duo[0].duo-integration-key=DIOXVRZD2UMZ8XXMNFQ5", "cas.authn.mfa.duo[0].trusted-device-enabled=true", "cas.authn.mfa.duo[0].duo-api-host=theapi.duosecurity.com"})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Tag(value="WebflowMfaActions")
public class DuoSecurityUniversalPromptValidateLoginActionTests
extends BaseCasWebflowMultifactorAuthenticationTests {
    @Autowired
    @Qualifier(value="duoUniversalPromptValidateLoginAction")
    private Action duoUniversalPromptValidateLoginAction;
    @Autowired
    @Qualifier(value="duoUniversalPromptPrepareLoginAction")
    private Action duoUniversalPromptPrepareLoginAction;

    @Test
    public void verifySkip() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        Event result = this.duoUniversalPromptValidateLoginAction.execute((RequestContext)context);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)"skip", (Object)result.getId());
    }

    @Test
    public void verifyError() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        request.addParameter("duo_code", "bad-code");
        request.addParameter("state", "bad-state");
        Event result = this.duoUniversalPromptValidateLoginAction.execute((RequestContext)context);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)"error", (Object)result.getId());
    }

    @Test
    public void verifyPass() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        String identifier = ((DuoSecurityMultifactorProperties)this.casProperties.getAuthn().getMfa().getDuo().get(0)).getId();
        MultifactorAuthenticationProvider provider = TestMultifactorAuthenticationProvider.registerProviderIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext, (MultifactorAuthenticationProvider)new TestMultifactorAuthenticationProvider(identifier));
        Authentication authentication = RegisteredServiceTestUtils.getAuthentication();
        WebUtils.putAuthentication((Authentication)authentication, (RequestContext)context);
        WebUtils.putRegisteredService((RequestContext)context, (RegisteredService)RegisteredServiceTestUtils.getRegisteredService());
        WebUtils.putMultifactorAuthenticationProviderIdIntoFlowScope((RequestContext)context, (MultifactorAuthenticationProvider)provider);
        AuthenticationResultBuilder builder = (AuthenticationResultBuilder)Mockito.mock(AuthenticationResultBuilder.class);
        Mockito.when((Object)builder.getInitialAuthentication()).thenReturn(Optional.of(authentication));
        Mockito.when((Object)builder.collect((Authentication)Mockito.any(Authentication.class))).thenReturn((Object)builder);
        WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)builder, (RequestContext)context);
        Event prepResult = this.duoUniversalPromptPrepareLoginAction.execute((RequestContext)context);
        TransientSessionTicket ticket = (TransientSessionTicket)prepResult.getAttributes().get("result");
        String code = UUID.randomUUID().toString();
        request.addParameter("duo_code", code);
        request.addParameter("state", ticket.getId());
        Event result = this.duoUniversalPromptValidateLoginAction.execute((RequestContext)context);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)"success", (Object)result.getId());
    }

    @TestConfiguration(value="DuoSecurityUniversalPromptValidateLoginActionTestConfiguration")
    public static class DuoSecurityUniversalPromptValidateLoginActionTestConfiguration {
        @Bean
        public MultifactorAuthenticationProviderBean<DuoSecurityMultifactorAuthenticationProvider, DuoSecurityMultifactorProperties> duoProviderBean() throws Exception {
            Token token = new Token();
            token.setSub("casuser");
            Client duoClient = (Client)Mockito.mock(Client.class);
            Mockito.when((Object)duoClient.generateState()).thenReturn((Object)UUID.randomUUID().toString());
            Mockito.when((Object)duoClient.createAuthUrl(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)"https://duo.com");
            Mockito.when((Object)duoClient.exchangeAuthorizationCodeFor2FAResult(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)token);
            DuoSecurityAuthenticationService duoAuthService = (DuoSecurityAuthenticationService)Mockito.mock(DuoSecurityAuthenticationService.class);
            Mockito.when((Object)duoAuthService.getDuoClient()).thenReturn(Optional.of(duoClient));
            Mockito.when((Object)duoAuthService.authenticate((Credential)Mockito.any())).thenReturn((Object)DuoSecurityAuthenticationResult.builder().success(true).username("casuser").build());
            DuoSecurityMultifactorAuthenticationProvider provider = (DuoSecurityMultifactorAuthenticationProvider)Mockito.mock(DuoSecurityMultifactorAuthenticationProvider.class);
            Mockito.when((Object)provider.getId()).thenReturn((Object)"mfa-duo");
            Mockito.when((Object)provider.createUniqueId()).thenReturn((Object)"mfa-duo");
            Mockito.when((Object)provider.validateId(Mockito.anyString())).thenReturn((Object)Boolean.TRUE);
            Mockito.when((Object)provider.getDuoAuthenticationService()).thenReturn((Object)duoAuthService);
            MultifactorAuthenticationProviderBean bean = (MultifactorAuthenticationProviderBean)Mockito.mock(MultifactorAuthenticationProviderBean.class);
            Mockito.when((Object)bean.getProvider(Mockito.anyString())).thenReturn((Object)provider);
            return bean;
        }
    }
}

