/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.duosecurity.Client;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.duo.DuoSecurityHealthIndicator;
import org.apereo.cas.adaptors.duo.authn.DefaultDuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationHandler;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityDirectCredential;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.duo.authn.UniversalPromptDuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.web.DuoSecurityAdminApiEndpoint;
import org.apereo.cas.adaptors.duo.web.DuoSecurityPingEndpoint;
import org.apereo.cas.adaptors.duo.web.DuoSecurityUserAccountStatusEndpoint;
import org.apereo.cas.adaptors.duo.web.flow.DuoSecurityMultifactorWebflowConfigurer;
import org.apereo.cas.adaptors.duo.web.flow.action.DuoSecurityDetermineUserAccountAction;
import org.apereo.cas.authentication.AbstractAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.MultifactorAuthenticationFailureModeEvaluator;
import org.apereo.cas.authentication.MultifactorAuthenticationHandler;
import org.apereo.cas.authentication.MultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.bypass.ChainingMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.handler.ByCredentialTypeAuthenticationHandlerResolver;
import org.apereo.cas.authentication.metadata.AuthenticationContextAttributeMetaDataPopulator;
import org.apereo.cas.authentication.metadata.BaseAuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.metadata.MultifactorAuthenticationProviderMetadataPopulator;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.mfa.duo.DuoSecurityMultifactorAuthenticationProperties;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.ImmutableInMemoryServiceRegistry;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.apereo.cas.util.spring.DirectObjectProvider;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.apereo.cas.web.flow.configurer.CasMultifactorWebflowCustomizer;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.PropertyResolver;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.MultifactorAuthentication}, module="duo")
@AutoConfiguration
public class DuoSecurityAuthenticationEventExecutionPlanConfiguration {
    private static final int WEBFLOW_CONFIGURER_ORDER = 0;

    @Configuration(value="SurrogateAuthenticationDuoSecurityWebflowPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnClass(value={SurrogateAuthenticationService.class})
    public static class SurrogateAuthenticationDuoSecurityWebflowPlanConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnClass(value={DuoSecurityAuthenticationService.class})
        @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.MultifactorAuthentication}, module="duo")
        public CasMultifactorWebflowCustomizer surrogateDuoSecurityMultifactorWebflowCustomizer(ConfigurableApplicationContext applicationContext) {
            return (CasMultifactorWebflowCustomizer)BeanSupplier.of(CasMultifactorWebflowCustomizer.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new CasMultifactorWebflowCustomizer(this){

                public List<String> getWebflowAttributeMappings() {
                    return List.of("requestSurrogateAccount");
                }
            }).otherwiseProxy().get();
        }

        @Bean
        @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.SurrogateAuthentication})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"surrogateDuoSecurityMultifactorAuthenticationWebflowConfigurer"})
        public CasWebflowConfigurer surrogateDuoSecurityMultifactorAuthenticationWebflowConfigurer(@Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new SurrogateWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties)).otherwiseProxy().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"surrogateDuoSecurityMultifactorAuthenticationWebflowExecutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExecutionPlanConfigurer surrogateDuoSecurityMultifactorAuthenticationWebflowExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="surrogateDuoSecurityMultifactorAuthenticationWebflowConfigurer") CasWebflowConfigurer surrogateWebflowConfigurer) {
            return (CasWebflowExecutionPlanConfigurer)BeanSupplier.of(CasWebflowExecutionPlanConfigurer.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerWebflowConfigurer(surrogateWebflowConfigurer)).otherwiseProxy().get();
        }

        private static final class SurrogateWebflowConfigurer
        extends AbstractCasWebflowConfigurer {
            SurrogateWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry mainFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
                super(flowBuilderServices, mainFlowDefinitionRegistry, applicationContext, casProperties);
                this.setOrder(1);
            }

            protected void doInitialize() {
                TransitionableState validateAction = this.getState(this.getLoginFlow(), "duoUniversalPromptPrepareValidate");
                this.createTransitionForState(validateAction, "success", "loadSurrogatesAction", true);
                List duoConfig = this.casProperties.getAuthn().getMfa().getDuo();
                duoConfig.forEach(duoCfg -> {
                    TransitionableState duoSuccess = this.getState(this.getLoginFlow(), duoCfg.getId());
                    if (duoSuccess != null) {
                        this.createTransitionForState(duoSuccess, "success", "loadSurrogatesAction", true);
                    }
                });
            }
        }
    }

    @Configuration(value="DuoSecurityAuthenticationEventExecutionPlanWebConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DuoSecurityAuthenticationEventExecutionPlanWebConfiguration {
        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DuoSecurityPingEndpoint duoPingEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return new DuoSecurityPingEndpoint(casProperties, (ApplicationContext)applicationContext);
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DuoSecurityUserAccountStatusEndpoint duoAccountStatusEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return new DuoSecurityUserAccountStatusEndpoint(casProperties, (ApplicationContext)applicationContext);
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DuoSecurityAdminApiEndpoint duoAdminApiEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return new DuoSecurityAdminApiEndpoint(casProperties, (ApplicationContext)applicationContext);
        }
    }

    @Configuration(value="DuoSecurityAuthenticationWebflowActionsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DuoSecurityAuthenticationWebflowActionsConfiguration {
        @ConditionalOnMissingBean(name={"duoMultifactorWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer duoMultifactorWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                DuoSecurityMultifactorWebflowConfigurer cfg = new DuoSecurityMultifactorWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)applicationContext));
                cfg.setOrder(0);
                return cfg;
            }).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"duoSecurityCasWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer duoSecurityCasWebflowExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="duoMultifactorWebflowConfigurer") CasWebflowConfigurer duoMultifactorWebflowConfigurer) {
            return (CasWebflowExecutionPlanConfigurer)BeanSupplier.of(CasWebflowExecutionPlanConfigurer.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerWebflowConfigurer(duoMultifactorWebflowConfigurer)).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"determineDuoUserAccountAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action determineDuoUserAccountAction(@Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> (Action)BeanSupplier.of(Action.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new DuoSecurityDetermineUserAccountAction(casProperties, servicesManager)).otherwise(() -> ConsumerExecutionAction.NONE).get()).withId("determineDuoUserAccountAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"duoServiceRegistryExecutionPlanConfigurer"})
        public ServiceRegistryExecutionPlanConfigurer duoServiceRegistryExecutionPlanConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return plan -> casProperties.getAuthn().getMfa().getDuo().stream().filter(duo -> StringUtils.isNotBlank((CharSequence)duo.getRegistration().getRegistrationUrl())).forEach(duo -> {
                String serviceId = (String)FunctionUtils.doUnchecked(() -> new URI(duo.getRegistration().getRegistrationUrl()).toURL().getHost());
                CasRegisteredService service = new CasRegisteredService();
                service.setId(RandomUtils.nextLong());
                service.setEvaluationOrder(Integer.MIN_VALUE);
                service.setName(service.getClass().getSimpleName());
                service.setDescription("Duo Security Registration URL for " + duo.getId());
                service.setServiceId(serviceId);
                plan.registerServiceRegistry((ServiceRegistry)new ImmutableInMemoryServiceRegistry(List.of(service), applicationContext, List.of()));
            });
        }
    }

    @Configuration(value="DuoSecurityAuthenticationEventExecutionPlanCoreConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DuoSecurityAuthenticationEventExecutionPlanCoreConfiguration {
        @Generated
        private static final Logger LOGGER = LoggerFactory.getLogger(DuoSecurityAuthenticationEventExecutionPlanCoreConfiguration.class);
        private static final int USER_ACCOUNT_CACHE_INITIAL_SIZE = 50;
        private static final long USER_ACCOUNT_CACHE_MAX_SIZE = 1000L;
        private static final int USER_ACCOUNT_CACHE_EXPIRATION_SECONDS = 5;

        @ConditionalOnMissingBean(name={"duoPrincipalFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalFactory duoPrincipalFactory(ConfigurableApplicationContext applicationContext) {
            return (PrincipalFactory)BeanSupplier.of(PrincipalFactory.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(PrincipalFactoryUtils::newPrincipalFactory).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"duoMultifactorAuthenticationProviders"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<MultifactorAuthenticationProvider> duoMultifactorAuthenticationProviders(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, List<MultifactorAuthenticationPrincipalResolver> multifactorAuthenticationPrincipalResolvers, @Qualifier(value="httpClient") HttpClient httpClient, @Qualifier(value="duoSecurityBypassEvaluator") ChainingMultifactorAuthenticationProviderBypassEvaluator duoSecurityBypassEvaluator, @Qualifier(value="failureModeEvaluator") MultifactorAuthenticationFailureModeEvaluator failureModeEvaluator) {
            return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                AnnotationAwareOrderComparator.sort((List)multifactorAuthenticationPrincipalResolvers);
                ArrayList listOfProviders = new ArrayList();
                casProperties.getAuthn().getMfa().getDuo().stream().map(duoProps -> {
                    DefaultDuoSecurityMultifactorAuthenticationProvider provider = new DefaultDuoSecurityMultifactorAuthenticationProvider();
                    provider.setFailureMode(duoProps.getFailureMode());
                    provider.setFailureModeEvaluator(failureModeEvaluator);
                    provider.setOrder(duoProps.getRank());
                    provider.setId(duoProps.getId());
                    provider.setRegistration(duoProps.getRegistration());
                    DuoSecurityAuthenticationService duoAuthenticationService = DuoSecurityAuthenticationEventExecutionPlanCoreConfiguration.getDuoAuthenticationService(applicationContext, multifactorAuthenticationPrincipalResolvers, httpClient, casProperties, duoProps);
                    String name = provider.getId().concat("-duoAuthenticationService");
                    ApplicationContextProvider.registerBeanIntoApplicationContext((ConfigurableApplicationContext)applicationContext, (Object)duoAuthenticationService, (String)name);
                    provider.setDuoAuthenticationService(duoAuthenticationService);
                    MultifactorAuthenticationProviderBypassEvaluator bypassEvaluator = duoSecurityBypassEvaluator.filterMultifactorAuthenticationProviderBypassEvaluatorsBy(duoProps.getId());
                    name = provider.getId().concat("-duoBypassEvaluator");
                    ApplicationContextProvider.registerBeanIntoApplicationContext((ConfigurableApplicationContext)applicationContext, (Object)bypassEvaluator, (String)name);
                    provider.setBypassEvaluator(bypassEvaluator);
                    return provider;
                }).forEach(provider -> {
                    String name = provider.getId().concat("-duoSecurityMfaProvider");
                    ApplicationContextProvider.registerBeanIntoApplicationContext((ConfigurableApplicationContext)applicationContext, (Object)provider, (String)name);
                    listOfProviders.add(provider);
                });
                return BeanContainer.of(listOfProviders);
            }).otherwise(BeanContainer::empty).get();
        }

        private static DuoSecurityAuthenticationService getDuoAuthenticationService(ConfigurableApplicationContext applicationContext, List<MultifactorAuthenticationPrincipalResolver> multifactorAuthenticationPrincipalResolvers, HttpClient httpClient, CasConfigurationProperties casProperties, DuoSecurityMultifactorAuthenticationProperties properties) {
            return (DuoSecurityAuthenticationService)FunctionUtils.doUnchecked(() -> {
                Cache cache = Caffeine.newBuilder().initialCapacity(50).maximumSize(1000L).expireAfterWrite(Duration.ofSeconds(5L)).build();
                LOGGER.trace("Activating universal prompt authentication service for duo security");
                SpringExpressionLanguageValueResolver resolver = SpringExpressionLanguageValueResolver.getInstance();
                Client duoClient = (Client)applicationContext.getBeanProvider(Client.class).getIfAvailable(Unchecked.supplier(() -> new Client.Builder(resolver.resolve(properties.getDuoIntegrationKey()), resolver.resolve(properties.getDuoSecretKey()), resolver.resolve(properties.getDuoApiHost()), casProperties.getServer().getLoginUrl()).build()));
                return new UniversalPromptDuoSecurityAuthenticationService(properties, httpClient, duoClient, multifactorAuthenticationPrincipalResolvers, cache);
            });
        }
    }

    @Configuration(value="DuoSecurityAuthenticationMonitorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DuoSecurityAuthenticationMonitorConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnEnabledHealthIndicator(value="duoSecurityHealthIndicator")
        public HealthIndicator duoSecurityHealthIndicator(ConfigurableApplicationContext applicationContext) {
            return (HealthIndicator)BeanSupplier.of(HealthIndicator.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new DuoSecurityHealthIndicator((ApplicationContext)applicationContext)).otherwiseProxy().get();
        }
    }

    @Configuration(value="DuoSecurityAuthenticationEventExecutionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class DuoSecurityAuthenticationEventExecutionConfiguration {
        private static BeanContainer<AuthenticationMetaDataPopulator> duoAuthenticationMetaDataPopulator(ConfigurableApplicationContext applicationContext, MultifactorAuthenticationHandler authenticationHandler, CasConfigurationProperties casProperties) {
            return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                String authenticationContextAttribute = casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute();
                AuthenticationContextAttributeMetaDataPopulator p1 = new AuthenticationContextAttributeMetaDataPopulator(casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute(), (AuthenticationHandler)authenticationHandler, ((MultifactorAuthenticationProvider)authenticationHandler.getMultifactorAuthenticationProvider().getObject()).getId());
                MultifactorAuthenticationProviderMetadataPopulator p2 = new MultifactorAuthenticationProviderMetadataPopulator(authenticationContextAttribute, authenticationHandler.getMultifactorAuthenticationProvider(), (ServicesManager)applicationContext.getBean(ServicesManager.class, new Object[]{ServicesManager.class}));
                return BeanContainer.of((Object[])new BaseAuthenticationMetaDataPopulator[]{p1, p2});
            }).otherwise(BeanContainer::empty).get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"duoAuthenticationHandlers"})
        @DependsOn(value={"duoMultifactorAuthenticationProviders"})
        public BeanContainer<MultifactorAuthenticationHandler> duoAuthenticationHandlers(ConfigurableApplicationContext applicationContext, List<MultifactorAuthenticationPrincipalResolver> resolvers, CasConfigurationProperties casProperties, @Qualifier(value="duoPrincipalFactory") PrincipalFactory duoPrincipalFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                AnnotationAwareOrderComparator.sort((List)resolvers);
                return BeanContainer.of(casProperties.getAuthn().getMfa().getDuo().stream().map(props -> {
                    DuoSecurityMultifactorAuthenticationProvider provider = MultifactorAuthenticationUtils.getMultifactorAuthenticationProviderById((String)props.getId(), (ApplicationContext)applicationContext).map(DuoSecurityMultifactorAuthenticationProvider.class::cast).orElseThrow(() -> new IllegalArgumentException("Unable to locate multifactor authentication provider by id " + props.getId()));
                    return new DuoSecurityAuthenticationHandler(props.getName(), servicesManager, duoPrincipalFactory, (ObjectProvider)new DirectObjectProvider((Object)provider), Integer.valueOf(props.getOrder()), resolvers);
                }).sorted(Comparator.comparing(AbstractAuthenticationHandler::getOrder)).collect(Collectors.toList()));
            }).otherwise(BeanContainer::empty).get();
        }

        @ConditionalOnMissingBean(name={"duoSecurityAuthenticationEventExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlanConfigurer duoSecurityAuthenticationEventExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="duoAuthenticationHandlers") BeanContainer<MultifactorAuthenticationHandler> duoAuthenticationHandlers) {
            return (AuthenticationEventExecutionPlanConfigurer)BeanSupplier.of(AuthenticationEventExecutionPlanConfigurer.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> {
                duoAuthenticationHandlers.toList().forEach(dh -> {
                    plan.registerAuthenticationHandler((AuthenticationHandler)dh);
                    BeanContainer<AuthenticationMetaDataPopulator> populators = DuoSecurityAuthenticationEventExecutionConfiguration.duoAuthenticationMetaDataPopulator(applicationContext, dh, casProperties);
                    plan.registerAuthenticationMetadataPopulators((Collection)populators.toList());
                });
                plan.registerAuthenticationHandlerResolver((AuthenticationHandlerResolver)new ByCredentialTypeAuthenticationHandlerResolver(new Class[]{DuoSecurityDirectCredential.class}));
            }).otherwiseProxy().get();
        }
    }
}

