/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.monitor;

import java.util.Formatter;
import net.sf.ehcache.Cache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.statistics.StatisticsGateway;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.monitor.CacheStatistics;

@Deprecated(since="6.2.0")
public class EhCacheStatistics
implements CacheStatistics {
    private static final double TOTAL_NUMBER_BYTES_IN_ONE_MEGABYTE = 1048510.0;
    private static final int PERCENTAGE_VALUE = 100;
    private final Cache cache;
    private final boolean useBytes;
    private long diskSize;
    private long heapSize;
    private long offHeapSize;

    public EhCacheStatistics(Cache cache) {
        this.cache = cache;
        this.useBytes = cache.getCacheConfiguration().getMaxBytesLocalDisk() > 0L;
    }

    public long getSize() {
        StatisticsGateway statistics = this.cache.getStatistics();
        if (this.useBytes) {
            this.diskSize = statistics.getLocalDiskSizeInBytes();
            this.heapSize = statistics.getLocalHeapSizeInBytes();
        } else {
            this.diskSize = statistics.getLocalDiskSize();
            this.heapSize = statistics.getLocalHeapSize();
        }
        this.offHeapSize = statistics.getLocalOffHeapSizeInBytes();
        return this.heapSize;
    }

    public long getCapacity() {
        CacheConfiguration config = this.cache.getCacheConfiguration();
        if (this.useBytes) {
            return config.getMaxBytesLocalDisk();
        }
        return config.getMaxEntriesLocalDisk();
    }

    public long getEvictions() {
        return this.cache.getStatistics().cacheEvictedCount();
    }

    public long getPercentFree() {
        long capacity = this.getCapacity();
        if (capacity == 0L) {
            return 0L;
        }
        return (int)((capacity - this.getSize()) * 100L / capacity);
    }

    public String getName() {
        return this.cache.getName();
    }

    public String toString(StringBuilder builder) {
        String name = this.getName();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            builder.append(name).append(':');
        }
        try (Formatter formatter = new Formatter(builder);){
            if (this.useBytes) {
                formatter.format("%.2f MB heap, ", (double)this.heapSize / 1048510.0);
                formatter.format("%.2f MB disk, ", (double)this.diskSize / 1048510.0);
            } else {
                builder.append(this.heapSize).append(" items in heap, ");
                builder.append(this.diskSize).append(" items on disk, ");
            }
            formatter.format("%.2f MB off-heap, ", (double)this.offHeapSize / 1048510.0);
            builder.append(this.getPercentFree()).append(" perfect free, ");
            builder.append(this.getEvictions()).append(" evictions");
        }
        return builder.toString();
    }
}

