/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.api;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apereo.cas.api.AuthenticationRequestRiskCalculator;

public class AuthenticationRiskScore {
    private final BigDecimal score;

    public AuthenticationRiskScore(BigDecimal score) {
        this.score = score;
    }

    public BigDecimal getScore() {
        return this.score;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("score", (Object)this.score).toString();
    }

    public boolean isHighestRisk() {
        return this.getScore().compareTo(AuthenticationRequestRiskCalculator.HIGHEST_RISK_SCORE) == 0;
    }

    public boolean isLowestRisk() {
        return this.getScore().compareTo(AuthenticationRequestRiskCalculator.LOWEST_RISK_SCORE) == 0;
    }

    public boolean isRiskGreaterThan(double threshold) {
        return this.getScore().compareTo(BigDecimal.valueOf(threshold)) > 0;
    }
}

