/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.api.AuthenticationRequestRiskCalculator;
import org.apereo.cas.api.AuthenticationRiskContingencyPlan;
import org.apereo.cas.api.AuthenticationRiskEvaluator;
import org.apereo.cas.api.AuthenticationRiskMitigator;
import org.apereo.cas.api.AuthenticationRiskNotifier;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.RiskBasedAuthenticationProperties;
import org.apereo.cas.configuration.model.support.sms.SmsProperties;
import org.apereo.cas.impl.calcs.DateTimeAuthenticationRequestRiskCalculator;
import org.apereo.cas.impl.calcs.GeoLocationAuthenticationRequestRiskCalculator;
import org.apereo.cas.impl.calcs.IpAddressAuthenticationRequestRiskCalculator;
import org.apereo.cas.impl.calcs.UserAgentAuthenticationRequestRiskCalculator;
import org.apereo.cas.impl.engine.DefaultAuthenticationRiskEvaluator;
import org.apereo.cas.impl.engine.DefaultAuthenticationRiskMitigator;
import org.apereo.cas.impl.notify.AuthenticationRiskEmailNotifier;
import org.apereo.cas.impl.notify.AuthenticationRiskTwilioSmsNotifier;
import org.apereo.cas.impl.plans.BaseAuthenticationRiskContingencyPlan;
import org.apereo.cas.impl.plans.BlockAuthenticationContingencyPlan;
import org.apereo.cas.impl.plans.MultifactorAuthenticationContingencyPlan;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.io.CommunicationsManager;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.RiskAwareAuthenticationWebflowConfigurer;
import org.apereo.cas.web.flow.RiskAwareAuthenticationWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;

@Configuration(value="electronicFenceConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableScheduling
public class ElectronicFenceConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElectronicFenceConfiguration.class);
    @Autowired
    @Qualifier(value="communicationsManager")
    private CommunicationsManager communicationsManager;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private TicketRegistrySupport ticketRegistrySupport;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="warnCookieGenerator")
    private CookieGenerator warnCookieGenerator;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;
    @Autowired(required=false)
    private FlowBuilderServices flowBuilderServices;
    @Autowired(required=false)
    @Qualifier(value="loginFlowRegistry")
    private FlowDefinitionRegistry loginFlowDefinitionRegistry;
    @Autowired
    @Qualifier(value="casEventRepository")
    private CasEventRepository casEventRepository;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="multifactorAuthenticationProviderSelector")
    private MultifactorAuthenticationProviderSelector selector;
    @Autowired
    @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver")
    private CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver;

    @ConditionalOnMissingBean(name={"authenticationRiskEmailNotifier"})
    @Bean
    @RefreshScope
    public AuthenticationRiskNotifier authenticationRiskEmailNotifier() {
        return new AuthenticationRiskEmailNotifier(this.communicationsManager);
    }

    @ConditionalOnMissingBean(name={"authenticationRiskSmsNotifier"})
    @Bean
    @RefreshScope
    public AuthenticationRiskNotifier authenticationRiskSmsNotifier() {
        return new AuthenticationRiskTwilioSmsNotifier(this.communicationsManager);
    }

    @ConditionalOnMissingBean(name={"riskAwareAuthenticationWebflowEventResolver"})
    @Bean
    @Autowired
    @RefreshScope
    public CasWebflowEventResolver riskAwareAuthenticationWebflowEventResolver(@Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport) {
        RiskAwareAuthenticationWebflowEventResolver r = new RiskAwareAuthenticationWebflowEventResolver(authenticationSystemSupport, this.centralAuthenticationService, this.servicesManager, this.ticketRegistrySupport, this.warnCookieGenerator, this.authenticationRequestServiceSelectionStrategies, this.selector, this.authenticationRiskEvaluator(), this.authenticationRiskMitigator(), this.casProperties);
        this.initialAuthenticationAttemptWebflowEventResolver.addDelegate((CasWebflowEventResolver)r, 0);
        return r;
    }

    @ConditionalOnMissingBean(name={"blockAuthenticationContingencyPlan"})
    @Bean
    @RefreshScope
    public AuthenticationRiskContingencyPlan blockAuthenticationContingencyPlan() {
        BlockAuthenticationContingencyPlan b = new BlockAuthenticationContingencyPlan();
        this.configureContingencyPlan(b);
        return b;
    }

    @ConditionalOnMissingBean(name={"multifactorAuthenticationContingencyPlan"})
    @Bean
    @RefreshScope
    public AuthenticationRiskContingencyPlan multifactorAuthenticationContingencyPlan() {
        MultifactorAuthenticationContingencyPlan b = new MultifactorAuthenticationContingencyPlan();
        this.configureContingencyPlan(b);
        return b;
    }

    @ConditionalOnMissingBean(name={"authenticationRiskMitigator"})
    @Bean
    @RefreshScope
    public AuthenticationRiskMitigator authenticationRiskMitigator() {
        if (this.casProperties.getAuthn().getAdaptive().getRisk().getResponse().isBlockAttempt()) {
            return new DefaultAuthenticationRiskMitigator(this.blockAuthenticationContingencyPlan());
        }
        return new DefaultAuthenticationRiskMitigator(this.multifactorAuthenticationContingencyPlan());
    }

    @ConditionalOnMissingBean(name={"ipAddressAuthenticationRequestRiskCalculator"})
    @Bean
    @RefreshScope
    public AuthenticationRequestRiskCalculator ipAddressAuthenticationRequestRiskCalculator() {
        return new IpAddressAuthenticationRequestRiskCalculator(this.casEventRepository);
    }

    @ConditionalOnMissingBean(name={"userAgentAuthenticationRequestRiskCalculator"})
    @Bean
    @RefreshScope
    public AuthenticationRequestRiskCalculator userAgentAuthenticationRequestRiskCalculator() {
        return new UserAgentAuthenticationRequestRiskCalculator(this.casEventRepository);
    }

    @ConditionalOnMissingBean(name={"dateTimeAuthenticationRequestRiskCalculator"})
    @Bean
    @RefreshScope
    public AuthenticationRequestRiskCalculator dateTimeAuthenticationRequestRiskCalculator() {
        return new DateTimeAuthenticationRequestRiskCalculator(this.casEventRepository, this.casProperties.getAuthn().getAdaptive().getRisk().getDateTime().getWindowInHours());
    }

    @ConditionalOnMissingBean(name={"geoLocationAuthenticationRequestRiskCalculator"})
    @Bean
    @RefreshScope
    public AuthenticationRequestRiskCalculator geoLocationAuthenticationRequestRiskCalculator() {
        return new GeoLocationAuthenticationRequestRiskCalculator(this.casEventRepository);
    }

    @ConditionalOnMissingBean(name={"riskAwareAuthenticationWebflowConfigurer"})
    @Bean
    @RefreshScope
    public CasWebflowConfigurer riskAwareAuthenticationWebflowConfigurer() {
        return new RiskAwareAuthenticationWebflowConfigurer(this.flowBuilderServices, this.loginFlowDefinitionRegistry);
    }

    @ConditionalOnMissingBean(name={"authenticationRiskEvaluator"})
    @Bean
    @RefreshScope
    public AuthenticationRiskEvaluator authenticationRiskEvaluator() {
        RiskBasedAuthenticationProperties risk = this.casProperties.getAuthn().getAdaptive().getRisk();
        HashSet<AuthenticationRequestRiskCalculator> calculators = new HashSet<AuthenticationRequestRiskCalculator>();
        if (risk.getIp().isEnabled()) {
            calculators.add(this.ipAddressAuthenticationRequestRiskCalculator());
        }
        if (risk.getAgent().isEnabled()) {
            calculators.add(this.userAgentAuthenticationRequestRiskCalculator());
        }
        if (risk.getDateTime().isEnabled()) {
            calculators.add(this.dateTimeAuthenticationRequestRiskCalculator());
        }
        if (risk.getGeoLocation().isEnabled()) {
            calculators.add(this.geoLocationAuthenticationRequestRiskCalculator());
        }
        if (calculators.isEmpty()) {
            LOGGER.warn("No risk calculators are defined to examine authentication requests");
        }
        return new DefaultAuthenticationRiskEvaluator(calculators);
    }

    private void configureContingencyPlan(BaseAuthenticationRiskContingencyPlan b) {
        SmsProperties sms;
        RiskBasedAuthenticationProperties.Response.Mail mail = this.casProperties.getAuthn().getAdaptive().getRisk().getResponse().getMail();
        if (StringUtils.isNotBlank((CharSequence)mail.getText()) && StringUtils.isNotBlank((CharSequence)mail.getFrom()) && StringUtils.isNotBlank((CharSequence)mail.getSubject())) {
            b.getNotifiers().add(this.authenticationRiskEmailNotifier());
        }
        if (StringUtils.isNotBlank((CharSequence)(sms = this.casProperties.getAuthn().getAdaptive().getRisk().getResponse().getSms()).getText()) && StringUtils.isNotBlank((CharSequence)sms.getFrom())) {
            b.getNotifiers().add(this.authenticationRiskSmsNotifier());
        }
    }
}

