/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.calcs;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.impl.calcs.BaseAuthenticationRequestRiskCalculator;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.dao.CasEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeAuthenticationRequestRiskCalculator
extends BaseAuthenticationRequestRiskCalculator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateTimeAuthenticationRequestRiskCalculator.class);
    private final int windowInHours;

    public DateTimeAuthenticationRequestRiskCalculator(CasEventRepository casEventRepository, int windowInHours) {
        super(casEventRepository);
        this.windowInHours = windowInHours;
    }

    @Override
    protected BigDecimal calculateScore(HttpServletRequest request, Authentication authentication, RegisteredService service, Collection<CasEvent> events) {
        ZonedDateTime timestamp = ZonedDateTime.now();
        LOGGER.debug("Filtering authentication events for timestamp [{}]", (Object)timestamp);
        long count = events.stream().filter(e -> e.getCreationTime().getHour() == timestamp.getHour() || e.getCreationTime().plusHours(this.windowInHours).getHour() == timestamp.getHour() || e.getCreationTime().minusHours(this.windowInHours).getHour() == timestamp.getHour()).count();
        LOGGER.debug("Total authentication events found for [{}]: [{}]", (Object)timestamp, (Object)count);
        if (count == (long)events.size()) {
            LOGGER.debug("Principal [{}] has always authenticated from [{}]", (Object)authentication.getPrincipal(), (Object)timestamp);
            return LOWEST_RISK_SCORE;
        }
        return this.getFinalAveragedScore(count, events.size());
    }
}

