/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.calcs;

import java.math.BigDecimal;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationResponse;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.impl.calcs.BaseAuthenticationRequestRiskCalculator;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.dao.CasEvent;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class GeoLocationAuthenticationRequestRiskCalculator
extends BaseAuthenticationRequestRiskCalculator {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoLocationAuthenticationRequestRiskCalculator.class);
    @Autowired
    @Qualifier(value="geoLocationService")
    protected GeoLocationService geoLocationService;

    public GeoLocationAuthenticationRequestRiskCalculator(CasEventRepository casEventRepository) {
        super(casEventRepository);
    }

    @Override
    protected BigDecimal calculateScore(HttpServletRequest request, Authentication authentication, RegisteredService service, Collection<CasEvent> events) {
        GeoLocationRequest loc = WebUtils.getHttpServletRequestGeoLocation();
        if (loc.isValid()) {
            LOGGER.debug("Filtering authentication events for geolocation [{}]", (Object)loc);
            long count = events.stream().filter(e -> e.getGeoLocation().equals((Object)loc)).count();
            LOGGER.debug("Total authentication events found for [{}]: [{}]", (Object)loc, (Object)count);
            if (count == (long)events.size()) {
                LOGGER.debug("Principal [{}] has always authenticated from [{}]", (Object)authentication.getPrincipal(), (Object)loc);
                return LOWEST_RISK_SCORE;
            }
            return this.getFinalAveragedScore(count, events.size());
        }
        String remoteAddr = ClientInfoHolder.getClientInfo().getClientIpAddress();
        LOGGER.debug("Filtering authentication events for location based on ip [{}]", (Object)remoteAddr);
        GeoLocationResponse response = this.geoLocationService.locate(remoteAddr);
        if (response != null) {
            long count = events.stream().filter(e -> e.getGeoLocation().equals((Object)new GeoLocationRequest(response.getLatitude(), response.getLongitude()))).count();
            LOGGER.debug("Total authentication events found for location of [{}]: [{}]", (Object)remoteAddr, (Object)count);
            if (count == (long)events.size()) {
                LOGGER.debug("Principal [{}] has always authenticated from [{}]", (Object)authentication.getPrincipal(), (Object)loc);
                return LOWEST_RISK_SCORE;
            }
            return this.getFinalAveragedScore(count, events.size());
        }
        LOGGER.debug("Request does not contain enough geolocation data");
        return HIGHEST_RISK_SCORE;
    }
}

