/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.calcs;

import java.math.BigDecimal;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.impl.calcs.BaseAuthenticationRequestRiskCalculator;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.dao.CasEvent;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentAuthenticationRequestRiskCalculator
extends BaseAuthenticationRequestRiskCalculator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAgentAuthenticationRequestRiskCalculator.class);

    public UserAgentAuthenticationRequestRiskCalculator(CasEventRepository casEventRepository) {
        super(casEventRepository);
    }

    @Override
    protected BigDecimal calculateScore(HttpServletRequest request, Authentication authentication, RegisteredService service, Collection<CasEvent> events) {
        String agent = WebUtils.getHttpServletRequestUserAgent((HttpServletRequest)request);
        LOGGER.debug("Filtering authentication events for user agent [{}]", (Object)agent);
        long count = events.stream().filter(e -> e.getAgent().equalsIgnoreCase(agent)).count();
        LOGGER.debug("Total authentication events found for [{}]: [{}]", (Object)agent, (Object)count);
        if (count == (long)events.size()) {
            LOGGER.debug("Principal [{}] has always authenticated from [{}]", (Object)authentication.getPrincipal(), (Object)agent);
            return LOWEST_RISK_SCORE;
        }
        return this.getFinalAveragedScore(count, events.size());
    }
}

