/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.engine;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.api.AuthenticationRequestRiskCalculator;
import org.apereo.cas.api.AuthenticationRiskEvaluator;
import org.apereo.cas.api.AuthenticationRiskScore;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.services.RegisteredService;
import org.apereo.inspektr.audit.annotation.Audit;

public class DefaultAuthenticationRiskEvaluator
implements AuthenticationRiskEvaluator {
    private final Set<AuthenticationRequestRiskCalculator> calculators;

    public DefaultAuthenticationRiskEvaluator(Set<AuthenticationRequestRiskCalculator> calculators) {
        this.calculators = calculators;
    }

    @Override
    public Set<AuthenticationRequestRiskCalculator> getCalculators() {
        return this.calculators;
    }

    @Override
    @Audit(action="EVALUATE_RISKY_AUTHENTICATION", actionResolverName="ADAPTIVE_RISKY_AUTHENTICATION_ACTION_RESOLVER", resourceResolverName="ADAPTIVE_RISKY_AUTHENTICATION_RESOURCE_RESOLVER")
    public AuthenticationRiskScore eval(Authentication authentication, RegisteredService service, HttpServletRequest request) {
        if (this.calculators.isEmpty()) {
            return new AuthenticationRiskScore(AuthenticationRequestRiskCalculator.HIGHEST_RISK_SCORE);
        }
        ArrayList scores = new ArrayList();
        this.calculators.stream().forEach(r -> scores.add(r.calculate(authentication, service, request)));
        BigDecimal sum = scores.stream().map(AuthenticationRiskScore::getScore).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal score = sum.divide(BigDecimal.valueOf(this.calculators.size()), 2, 0);
        return new AuthenticationRiskScore(score);
    }
}

