/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.notify;

import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.core.authentication.RiskBasedAuthenticationProperties;
import org.apereo.cas.impl.notify.BaseAuthenticationRiskNotifier;
import org.apereo.cas.util.io.CommunicationsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationRiskEmailNotifier
extends BaseAuthenticationRiskNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationRiskEmailNotifier.class);
    private final CommunicationsManager communicationsManager;

    public AuthenticationRiskEmailNotifier(CommunicationsManager communicationsManager) {
        this.communicationsManager = communicationsManager;
    }

    @Override
    public void publish() {
        RiskBasedAuthenticationProperties.Response.Mail mail = this.casProperties.getAuthn().getAdaptive().getRisk().getResponse().getMail();
        Principal principal = this.authentication.getPrincipal();
        if (!principal.getAttributes().containsKey(mail.getAttributeName())) {
            LOGGER.debug("Could not send email [{}] because either no addresses could be found or email settings are not configured.", (Object)principal.getId());
            return;
        }
        String to = principal.getAttributes().get(mail.getAttributeName()).toString();
        this.communicationsManager.email(mail.getText(), mail.getFrom(), mail.getSubject(), to, mail.getCc(), mail.getBcc());
    }
}

