/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.notify;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.sms.SmsProperties;
import org.apereo.cas.impl.notify.BaseAuthenticationRiskNotifier;
import org.apereo.cas.util.io.CommunicationsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationRiskTwilioSmsNotifier
extends BaseAuthenticationRiskNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationRiskTwilioSmsNotifier.class);
    private final CommunicationsManager communicationsManager;

    public AuthenticationRiskTwilioSmsNotifier(CommunicationsManager communicationsManager) {
        this.communicationsManager = communicationsManager;
    }

    @Override
    public void publish() {
        SmsProperties sms = this.casProperties.getAuthn().getAdaptive().getRisk().getResponse().getSms();
        Principal principal = this.authentication.getPrincipal();
        if (StringUtils.isBlank((CharSequence)sms.getText()) || StringUtils.isBlank((CharSequence)sms.getFrom()) || !principal.getAttributes().containsKey(sms.getAttributeName())) {
            LOGGER.debug("Could not send sms [{}] because either no phones could be found or sms settings are not configured.", (Object)principal.getId());
            return;
        }
        this.communicationsManager.sms(sms.getFrom(), principal.getAttributes().get(sms.getAttributeName()).toString(), sms.getText());
    }
}

