/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.api.AuthenticationRiskContingencyResponse;
import org.apereo.cas.api.AuthenticationRiskEvaluator;
import org.apereo.cas.api.AuthenticationRiskMitigator;
import org.apereo.cas.api.AuthenticationRiskScore;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.events.authentication.adaptive.CasRiskBasedAuthenticationEvaluationStartedEvent;
import org.apereo.cas.support.events.authentication.adaptive.CasRiskBasedAuthenticationMitigationStartedEvent;
import org.apereo.cas.support.events.authentication.adaptive.CasRiskyAuthenticationDetectedEvent;
import org.apereo.cas.support.events.authentication.adaptive.CasRiskyAuthenticationMitigatedEvent;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.flow.resolver.impl.AbstractCasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class RiskAwareAuthenticationWebflowEventResolver
extends AbstractCasWebflowEventResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(RiskAwareAuthenticationWebflowEventResolver.class);
    private final AuthenticationRiskEvaluator authenticationRiskEvaluator;
    private final AuthenticationRiskMitigator authenticationRiskMitigator;
    private final double threshold;

    public RiskAwareAuthenticationWebflowEventResolver(AuthenticationSystemSupport authenticationSystemSupport, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, CookieGenerator warnCookieGenerator, AuthenticationServiceSelectionPlan authenticationSelectionStrategies, MultifactorAuthenticationProviderSelector selector, AuthenticationRiskEvaluator authenticationRiskEvaluator, AuthenticationRiskMitigator authenticationRiskMitigator, CasConfigurationProperties casProperties) {
        super(authenticationSystemSupport, centralAuthenticationService, servicesManager, ticketRegistrySupport, warnCookieGenerator, authenticationSelectionStrategies, selector);
        this.authenticationRiskEvaluator = authenticationRiskEvaluator;
        this.authenticationRiskMitigator = authenticationRiskMitigator;
        this.threshold = casProperties.getAuthn().getAdaptive().getRisk().getThreshold();
    }

    public Set<Event> resolveInternal(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        RegisteredService service = WebUtils.getRegisteredService((RequestContext)context);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)context);
        if (service == null || authentication == null) {
            LOGGER.debug("No service or authentication is available to determine event for principal");
            return null;
        }
        return this.handlePossibleSuspiciousAttempt(request, authentication, service);
    }

    protected Set<Event> handlePossibleSuspiciousAttempt(HttpServletRequest request, Authentication authentication, RegisteredService service) {
        this.eventPublisher.publishEvent((ApplicationEvent)new CasRiskBasedAuthenticationEvaluationStartedEvent((Object)this, authentication, service));
        LOGGER.debug("Evaluating possible suspicious authentication attempt for [{}]", (Object)authentication.getPrincipal());
        AuthenticationRiskScore score = this.authenticationRiskEvaluator.eval(authentication, service, request);
        if (score.isRiskGreaterThan(this.threshold)) {
            this.eventPublisher.publishEvent((ApplicationEvent)new CasRiskyAuthenticationDetectedEvent((Object)this, authentication, service, (Object)score));
            LOGGER.debug("Calculated risk score [{}] for authentication request by [{}] is above the risk threshold [{}].", new Object[]{score.getScore(), authentication.getPrincipal(), this.threshold});
            this.eventPublisher.publishEvent((ApplicationEvent)new CasRiskBasedAuthenticationMitigationStartedEvent((Object)this, authentication, service, (Object)score));
            AuthenticationRiskContingencyResponse res = this.authenticationRiskMitigator.mitigate(authentication, service, score, request);
            this.eventPublisher.publishEvent((ApplicationEvent)new CasRiskyAuthenticationMitigatedEvent((Object)this, authentication, service, (Object)res));
            return Collections.singleton(res.getResult());
        }
        LOGGER.debug("Authentication request for [{}] is below the risk threshold", (Object)authentication.getPrincipal());
        return null;
    }
}

