/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.HashSet;
import lombok.Generated;
import org.apereo.cas.api.AuthenticationRequestRiskCalculator;
import org.apereo.cas.api.AuthenticationRiskContingencyPlan;
import org.apereo.cas.api.AuthenticationRiskEvaluator;
import org.apereo.cas.api.AuthenticationRiskMitigator;
import org.apereo.cas.api.AuthenticationRiskNotifier;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.RiskBasedAuthenticationProperties;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.configuration.model.support.sms.SmsProperties;
import org.apereo.cas.impl.calcs.DateTimeAuthenticationRequestRiskCalculator;
import org.apereo.cas.impl.calcs.GeoLocationAuthenticationRequestRiskCalculator;
import org.apereo.cas.impl.calcs.IpAddressAuthenticationRequestRiskCalculator;
import org.apereo.cas.impl.calcs.UserAgentAuthenticationRequestRiskCalculator;
import org.apereo.cas.impl.engine.DefaultAuthenticationRiskEvaluator;
import org.apereo.cas.impl.engine.DefaultAuthenticationRiskMitigator;
import org.apereo.cas.impl.notify.AuthenticationRiskEmailNotifier;
import org.apereo.cas.impl.notify.AuthenticationRiskSmsNotifier;
import org.apereo.cas.impl.plans.BaseAuthenticationRiskContingencyPlan;
import org.apereo.cas.impl.plans.BlockAuthenticationContingencyPlan;
import org.apereo.cas.impl.plans.MultifactorAuthenticationContingencyPlan;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration(value="electronicFenceConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableScheduling
public class ElectronicFenceConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ElectronicFenceConfiguration.class);
    @Autowired
    @Qualifier(value="geoLocationService")
    private ObjectProvider<GeoLocationService> geoLocationService;
    @Autowired
    @Qualifier(value="returnValueResourceResolver")
    private ObjectProvider<AuditResourceResolver> returnValueResourceResolver;
    @Autowired
    @Qualifier(value="communicationsManager")
    private ObjectProvider<CommunicationsManager> communicationsManager;
    @Autowired
    @Qualifier(value="casEventRepository")
    private ObjectProvider<CasEventRepository> casEventRepository;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnMissingBean(name={"authenticationRiskEmailNotifier"})
    @Bean
    @RefreshScope
    public AuthenticationRiskNotifier authenticationRiskEmailNotifier() {
        return new AuthenticationRiskEmailNotifier(this.casProperties, (CommunicationsManager)this.communicationsManager.getObject());
    }

    @ConditionalOnMissingBean(name={"authenticationRiskSmsNotifier"})
    @Bean
    @RefreshScope
    public AuthenticationRiskNotifier authenticationRiskSmsNotifier() {
        return new AuthenticationRiskSmsNotifier(this.casProperties, (CommunicationsManager)this.communicationsManager.getObject());
    }

    @ConditionalOnMissingBean(name={"blockAuthenticationContingencyPlan"})
    @Bean
    @RefreshScope
    public AuthenticationRiskContingencyPlan blockAuthenticationContingencyPlan() {
        BlockAuthenticationContingencyPlan b = new BlockAuthenticationContingencyPlan(this.casProperties, (ApplicationContext)this.applicationContext);
        this.configureContingencyPlan(b);
        return b;
    }

    @ConditionalOnMissingBean(name={"multifactorAuthenticationContingencyPlan"})
    @Bean
    @RefreshScope
    public AuthenticationRiskContingencyPlan multifactorAuthenticationContingencyPlan() {
        MultifactorAuthenticationContingencyPlan b = new MultifactorAuthenticationContingencyPlan(this.casProperties, (ApplicationContext)this.applicationContext);
        this.configureContingencyPlan(b);
        return b;
    }

    @ConditionalOnMissingBean(name={"authenticationRiskMitigator"})
    @Bean
    @RefreshScope
    public AuthenticationRiskMitigator authenticationRiskMitigator() {
        if (this.casProperties.getAuthn().getAdaptive().getRisk().getResponse().isBlockAttempt()) {
            return new DefaultAuthenticationRiskMitigator(this.blockAuthenticationContingencyPlan());
        }
        return new DefaultAuthenticationRiskMitigator(this.multifactorAuthenticationContingencyPlan());
    }

    @ConditionalOnMissingBean(name={"ipAddressAuthenticationRequestRiskCalculator"})
    @Bean
    @RefreshScope
    public AuthenticationRequestRiskCalculator ipAddressAuthenticationRequestRiskCalculator() {
        return new IpAddressAuthenticationRequestRiskCalculator((CasEventRepository)this.casEventRepository.getObject(), this.casProperties);
    }

    @ConditionalOnMissingBean(name={"userAgentAuthenticationRequestRiskCalculator"})
    @Bean
    @RefreshScope
    public AuthenticationRequestRiskCalculator userAgentAuthenticationRequestRiskCalculator() {
        return new UserAgentAuthenticationRequestRiskCalculator((CasEventRepository)this.casEventRepository.getObject(), this.casProperties);
    }

    @ConditionalOnMissingBean(name={"dateTimeAuthenticationRequestRiskCalculator"})
    @Bean
    @RefreshScope
    public AuthenticationRequestRiskCalculator dateTimeAuthenticationRequestRiskCalculator() {
        return new DateTimeAuthenticationRequestRiskCalculator((CasEventRepository)this.casEventRepository.getObject(), this.casProperties);
    }

    @ConditionalOnMissingBean(name={"geoLocationAuthenticationRequestRiskCalculator"})
    @Bean
    @RefreshScope
    public AuthenticationRequestRiskCalculator geoLocationAuthenticationRequestRiskCalculator() {
        return new GeoLocationAuthenticationRequestRiskCalculator((CasEventRepository)this.casEventRepository.getObject(), this.casProperties, (GeoLocationService)this.geoLocationService.getIfAvailable());
    }

    @ConditionalOnMissingBean(name={"authenticationRiskEvaluator"})
    @Bean
    @RefreshScope
    public AuthenticationRiskEvaluator authenticationRiskEvaluator() {
        RiskBasedAuthenticationProperties risk = this.casProperties.getAuthn().getAdaptive().getRisk();
        HashSet<AuthenticationRequestRiskCalculator> calculators = new HashSet<AuthenticationRequestRiskCalculator>();
        if (risk.getIp().isEnabled()) {
            calculators.add(this.ipAddressAuthenticationRequestRiskCalculator());
        }
        if (risk.getAgent().isEnabled()) {
            calculators.add(this.userAgentAuthenticationRequestRiskCalculator());
        }
        if (risk.getDateTime().isEnabled()) {
            calculators.add(this.dateTimeAuthenticationRequestRiskCalculator());
        }
        if (risk.getGeoLocation().isEnabled()) {
            calculators.add(this.geoLocationAuthenticationRequestRiskCalculator());
        }
        if (calculators.isEmpty()) {
            LOGGER.warn("No risk calculators are defined to examine authentication requests");
        }
        return new DefaultAuthenticationRiskEvaluator(calculators);
    }

    @Bean
    @ConditionalOnMissingBean(name={"casElectrofenceAuditTrailRecordResolutionPlanConfigurer"})
    public AuditTrailRecordResolutionPlanConfigurer casElectrofenceAuditTrailRecordResolutionPlanConfigurer() {
        return plan -> {
            plan.registerAuditActionResolver("ADAPTIVE_RISKY_AUTHENTICATION_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver());
            plan.registerAuditResourceResolver("ADAPTIVE_RISKY_AUTHENTICATION_RESOURCE_RESOLVER", (AuditResourceResolver)this.returnValueResourceResolver.getObject());
        };
    }

    private void configureContingencyPlan(BaseAuthenticationRiskContingencyPlan b) {
        SmsProperties sms;
        RiskBasedAuthenticationProperties.Response response = this.casProperties.getAuthn().getAdaptive().getRisk().getResponse();
        EmailProperties mail = response.getMail();
        if (mail.isDefined()) {
            b.getNotifiers().add(this.authenticationRiskEmailNotifier());
        }
        if ((sms = response.getSms()).isDefined()) {
            b.getNotifiers().add(this.authenticationRiskSmsNotifier());
        }
    }
}

