/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.calcs;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.api.AuthenticationRequestRiskCalculator;
import org.apereo.cas.api.AuthenticationRiskScore;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.dao.CasEvent;
import org.apereo.cas.support.events.ticket.CasTicketGrantingTicketCreatedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAuthenticationRequestRiskCalculator
implements AuthenticationRequestRiskCalculator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseAuthenticationRequestRiskCalculator.class);
    protected final CasEventRepository casEventRepository;
    protected final CasConfigurationProperties casProperties;

    @Override
    public final AuthenticationRiskScore calculate(Authentication authentication, RegisteredService service, HttpServletRequest request) {
        Principal principal = authentication.getPrincipal();
        Collection<? extends CasEvent> events = this.getCasTicketGrantingTicketCreatedEventsFor(principal.getId());
        if (events.isEmpty()) {
            return new AuthenticationRiskScore(HIGHEST_RISK_SCORE);
        }
        AuthenticationRiskScore score = new AuthenticationRiskScore(this.calculateScore(request, authentication, service, events));
        LOGGER.debug("Calculated authentication risk score by [{}] is [{}]", (Object)this.getClass().getSimpleName(), (Object)score);
        return score;
    }

    protected BigDecimal calculateScore(HttpServletRequest request, Authentication authentication, RegisteredService service, Collection<? extends CasEvent> events) {
        return HIGHEST_RISK_SCORE;
    }

    protected Collection<? extends CasEvent> getCasTicketGrantingTicketCreatedEventsFor(String principal) {
        String type = CasTicketGrantingTicketCreatedEvent.class.getName();
        LOGGER.debug("Retrieving events of type [{}] for [{}]", (Object)type, (Object)principal);
        ZonedDateTime date = ZonedDateTime.now(ZoneOffset.UTC).minusDays(this.casProperties.getAuthn().getAdaptive().getRisk().getDaysInRecentHistory());
        return this.casEventRepository.getEventsOfTypeForPrincipal(type, principal, date);
    }

    protected BigDecimal calculateScoreBasedOnEventsCount(Authentication authentication, Collection<? extends CasEvent> events, long count) {
        if (count == (long)events.size()) {
            LOGGER.debug("Principal [{}] is assigned to the lowest risk score with attempted count of [{}]", (Object)authentication.getPrincipal(), (Object)count);
            return LOWEST_RISK_SCORE;
        }
        return this.getFinalAveragedScore(count, events.size());
    }

    protected BigDecimal getFinalAveragedScore(long eventCount, long total) {
        BigDecimal score = BigDecimal.valueOf(eventCount).divide(BigDecimal.valueOf(total), 2, RoundingMode.HALF_UP);
        return HIGHEST_RISK_SCORE.subtract(score);
    }

    @Generated
    protected BaseAuthenticationRequestRiskCalculator(CasEventRepository casEventRepository, CasConfigurationProperties casProperties) {
        this.casEventRepository = casEventRepository;
        this.casProperties = casProperties;
    }
}

