/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.calcs;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.impl.calcs.BaseAuthenticationRequestRiskCalculator;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.dao.CasEvent;
import org.apereo.cas.util.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeAuthenticationRequestRiskCalculator
extends BaseAuthenticationRequestRiskCalculator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DateTimeAuthenticationRequestRiskCalculator.class);

    public DateTimeAuthenticationRequestRiskCalculator(CasEventRepository casEventRepository, CasConfigurationProperties casProperties) {
        super(casEventRepository, casProperties);
    }

    @Override
    protected BigDecimal calculateScore(HttpServletRequest request, Authentication authentication, RegisteredService service, Collection<? extends CasEvent> events) {
        int windowInHours = this.casProperties.getAuthn().getAdaptive().getRisk().getDateTime().getWindowInHours();
        ZonedDateTime timestamp = ZonedDateTime.now(ZoneOffset.UTC);
        LOGGER.debug("Filtering authentication events for timestamp [{}]", (Object)timestamp);
        int hoursFromNow = timestamp.plusHours(windowInHours).getHour();
        int hoursBeforeNow = timestamp.minusHours(windowInHours).getHour();
        long count = events.stream().map(time -> {
            ZonedDateTime dt = DateTimeUtils.convertToZonedDateTime((String)time.getCreationTime());
            Instant instant = ChronoZonedDateTime.from(dt).toInstant();
            ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, ZoneOffset.UTC);
            return zdt.getHour();
        }).filter(hour -> hoursBeforeNow <= hoursFromNow ? hour >= hoursBeforeNow && hour <= hoursFromNow : hour >= hoursBeforeNow || hour <= hoursFromNow).count();
        LOGGER.debug("Total authentication events found for [{}] in a [{}]h window: [{}]", new Object[]{timestamp, windowInHours, count});
        return this.calculateScoreBasedOnEventsCount(authentication, events, count);
    }
}

