/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.calcs;

import java.math.BigDecimal;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationResponse;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.impl.calcs.BaseAuthenticationRequestRiskCalculator;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.dao.CasEvent;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoLocationAuthenticationRequestRiskCalculator
extends BaseAuthenticationRequestRiskCalculator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoLocationAuthenticationRequestRiskCalculator.class);
    private final GeoLocationService geoLocationService;

    public GeoLocationAuthenticationRequestRiskCalculator(CasEventRepository casEventRepository, CasConfigurationProperties casProperties, GeoLocationService geoLocationService) {
        super(casEventRepository, casProperties);
        this.geoLocationService = geoLocationService;
    }

    @Override
    protected BigDecimal calculateScore(HttpServletRequest request, Authentication authentication, RegisteredService service, Collection<? extends CasEvent> events) {
        GeoLocationRequest loc = WebUtils.getHttpServletRequestGeoLocation((HttpServletRequest)request);
        if (loc != null && loc.isValid()) {
            LOGGER.debug("Filtering authentication events for geolocation [{}]", (Object)loc);
            long count = events.stream().filter(e -> e.getGeoLocation().equals((Object)loc)).count();
            LOGGER.debug("Total authentication events found for [{}]: [{}]", (Object)loc, (Object)count);
            return this.calculateScoreBasedOnEventsCount(authentication, events, count);
        }
        String remoteAddr = ClientInfoHolder.getClientInfo().getClientIpAddress();
        LOGGER.debug("Filtering authentication events for location based on ip [{}]", (Object)remoteAddr);
        GeoLocationResponse response = this.geoLocationService.locate(remoteAddr);
        if (response != null) {
            long count = events.stream().filter(e -> e.getGeoLocation().equals((Object)new GeoLocationRequest(response.getLatitude(), response.getLongitude()))).count();
            LOGGER.debug("Total authentication events found for location of [{}]: [{}]", (Object)remoteAddr, (Object)count);
            return this.calculateScoreBasedOnEventsCount(authentication, events, count);
        }
        LOGGER.debug("Request does not contain enough geolocation data");
        return HIGHEST_RISK_SCORE;
    }
}

