/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.calcs;

import java.math.BigDecimal;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.impl.calcs.BaseAuthenticationRequestRiskCalculator;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.dao.CasEvent;
import org.apereo.cas.util.HttpRequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentAuthenticationRequestRiskCalculator
extends BaseAuthenticationRequestRiskCalculator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAgentAuthenticationRequestRiskCalculator.class);

    public UserAgentAuthenticationRequestRiskCalculator(CasEventRepository casEventRepository, CasConfigurationProperties casProperties) {
        super(casEventRepository, casProperties);
    }

    @Override
    protected BigDecimal calculateScore(HttpServletRequest request, Authentication authentication, RegisteredService service, Collection<? extends CasEvent> events) {
        String agent = HttpRequestUtils.getHttpServletRequestUserAgent((HttpServletRequest)request);
        LOGGER.debug("Filtering authentication events for user agent [{}]", (Object)agent);
        long count = events.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getAgent())).filter(e -> e.getAgent().equalsIgnoreCase(agent)).count();
        LOGGER.debug("Total authentication events found for [{}]: [{}]", (Object)agent, (Object)count);
        return this.calculateScoreBasedOnEventsCount(authentication, events, count);
    }
}

