/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.engine;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.api.AuthenticationRequestRiskCalculator;
import org.apereo.cas.api.AuthenticationRiskEvaluator;
import org.apereo.cas.api.AuthenticationRiskScore;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.services.RegisteredService;
import org.apereo.inspektr.audit.annotation.Audit;

public class DefaultAuthenticationRiskEvaluator
implements AuthenticationRiskEvaluator {
    private final Set<AuthenticationRequestRiskCalculator> calculators;

    @Override
    @Audit(action="EVALUATE_RISKY_AUTHENTICATION", actionResolverName="ADAPTIVE_RISKY_AUTHENTICATION_ACTION_RESOLVER", resourceResolverName="ADAPTIVE_RISKY_AUTHENTICATION_RESOURCE_RESOLVER")
    public AuthenticationRiskScore eval(Authentication authentication, RegisteredService service, HttpServletRequest request) {
        if (this.calculators.isEmpty()) {
            return new AuthenticationRiskScore(AuthenticationRequestRiskCalculator.HIGHEST_RISK_SCORE);
        }
        ArrayList scores = new ArrayList(this.calculators.size());
        this.calculators.forEach(r -> scores.add(r.calculate(authentication, service, request)));
        BigDecimal sum = scores.stream().map(AuthenticationRiskScore::getScore).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal score = sum.divide(BigDecimal.valueOf(this.calculators.size()), 2, RoundingMode.UP);
        return new AuthenticationRiskScore(score);
    }

    @Override
    @Generated
    public Set<AuthenticationRequestRiskCalculator> getCalculators() {
        return this.calculators;
    }

    @Generated
    public DefaultAuthenticationRiskEvaluator(Set<AuthenticationRequestRiskCalculator> calculators) {
        this.calculators = calculators;
    }
}

