/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.notify;

import java.util.List;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.impl.notify.BaseAuthenticationRiskNotifier;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.notifications.mail.EmailMessageBodyBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationRiskEmailNotifier
extends BaseAuthenticationRiskNotifier {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationRiskEmailNotifier.class);
    private final CommunicationsManager communicationsManager;

    public AuthenticationRiskEmailNotifier(CasConfigurationProperties casProperties, CommunicationsManager communicationsManager) {
        super(casProperties);
        this.communicationsManager = communicationsManager;
    }

    @Override
    public void publish() {
        EmailProperties mail = this.casProperties.getAuthn().getAdaptive().getRisk().getResponse().getMail();
        Principal principal = this.authentication.getPrincipal();
        if (!principal.getAttributes().containsKey(mail.getAttributeName())) {
            LOGGER.debug("Could not send email to [{}]. Either no addresses could be found or email settings are not configured.", (Object)principal.getId());
            return;
        }
        List addresses = (List)principal.getAttributes().get(mail.getAttributeName());
        String body = EmailMessageBodyBuilder.builder().properties(mail).build().produce();
        addresses.forEach(address -> this.communicationsManager.email(mail, address.toString(), body));
    }
}

