/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.notify;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.sms.SmsProperties;
import org.apereo.cas.impl.notify.BaseAuthenticationRiskNotifier;
import org.apereo.cas.notifications.CommunicationsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationRiskSmsNotifier
extends BaseAuthenticationRiskNotifier {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationRiskSmsNotifier.class);
    private final CommunicationsManager communicationsManager;

    public AuthenticationRiskSmsNotifier(CasConfigurationProperties casProperties, CommunicationsManager communicationsManager) {
        super(casProperties);
        this.communicationsManager = communicationsManager;
    }

    @Override
    public void publish() {
        SmsProperties sms = this.casProperties.getAuthn().getAdaptive().getRisk().getResponse().getSms();
        Principal principal = this.authentication.getPrincipal();
        if (StringUtils.isBlank((CharSequence)sms.getText()) || StringUtils.isBlank((CharSequence)sms.getFrom()) || !principal.getAttributes().containsKey(sms.getAttributeName())) {
            LOGGER.debug("Could not send sms [{}] because either no phones could be found or sms settings are not configured.", (Object)principal.getId());
            return;
        }
        String to = ((List)principal.getAttributes().get(sms.getAttributeName())).toString();
        this.communicationsManager.sms(sms.getFrom(), to, sms.getFormattedText(new Object[0]));
    }

    @Generated
    public CommunicationsManager getCommunicationsManager() {
        return this.communicationsManager;
    }
}

