/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.plans;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.api.AuthenticationRiskContingencyPlan;
import org.apereo.cas.api.AuthenticationRiskContingencyResponse;
import org.apereo.cas.api.AuthenticationRiskNotifier;
import org.apereo.cas.api.AuthenticationRiskScore;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class BaseAuthenticationRiskContingencyPlan
implements AuthenticationRiskContingencyPlan {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseAuthenticationRiskContingencyPlan.class);
    protected final CasConfigurationProperties casProperties;
    protected final ApplicationContext applicationContext;
    private final Set<AuthenticationRiskNotifier> notifiers = new LinkedHashSet<AuthenticationRiskNotifier>(0);

    @Override
    public final AuthenticationRiskContingencyResponse execute(Authentication authentication, RegisteredService service, AuthenticationRiskScore score, HttpServletRequest request) {
        LOGGER.debug("Executing [{}] to produce a risk response", (Object)this.getClass().getSimpleName());
        this.notifiers.forEach(e -> {
            e.setAuthentication(authentication);
            e.setAuthenticationRiskScore(score);
            e.setRegisteredService(service);
            LOGGER.debug("Executing risk notification [{}]", (Object)e.getClass().getSimpleName());
            new Thread((Runnable)e, e.getClass().getSimpleName()).start();
        });
        return this.executeInternal(authentication, service, score, request);
    }

    public Set<AuthenticationRiskNotifier> getNotifiers() {
        return this.notifiers;
    }

    protected AuthenticationRiskContingencyResponse executeInternal(Authentication authentication, RegisteredService service, AuthenticationRiskScore score, HttpServletRequest request) {
        return null;
    }

    @Generated
    protected BaseAuthenticationRiskContingencyPlan(CasConfigurationProperties casProperties, ApplicationContext applicationContext) {
        this.casProperties = casProperties;
        this.applicationContext = applicationContext;
    }
}

