/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.plans;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.api.AuthenticationRiskContingencyResponse;
import org.apereo.cas.api.AuthenticationRiskScore;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.impl.plans.BaseAuthenticationRiskContingencyPlan;
import org.apereo.cas.services.RegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.execution.Event;

public class MultifactorAuthenticationContingencyPlan
extends BaseAuthenticationRiskContingencyPlan {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationContingencyPlan.class);

    public MultifactorAuthenticationContingencyPlan(CasConfigurationProperties casProperties, ApplicationContext applicationContext) {
        super(casProperties, applicationContext);
    }

    @Override
    protected AuthenticationRiskContingencyResponse executeInternal(Authentication authentication, RegisteredService service, AuthenticationRiskScore score, HttpServletRequest request) {
        String id = this.casProperties.getAuthn().getAdaptive().getRisk().getResponse().getMfaProvider();
        if (StringUtils.isBlank((CharSequence)id)) {
            Map providerMap = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
            if (providerMap.isEmpty()) {
                LOGGER.warn("No multifactor authentication providers are available in the application context");
                throw new AuthenticationException();
            }
            if (providerMap.size() == 1) {
                id = ((MultifactorAuthenticationProvider)providerMap.values().iterator().next()).getId();
            } else {
                LOGGER.warn("No multifactor authentication providers are specified to handle risk-based authentication");
                throw new AuthenticationException();
            }
        }
        String attributeName = this.casProperties.getAuthn().getAdaptive().getRisk().getResponse().getRiskyAuthenticationAttribute();
        Authentication newAuthn = DefaultAuthenticationBuilder.newInstance((Authentication)authentication).addAttribute(attributeName, (Object)Boolean.TRUE).build();
        LOGGER.debug("Updated authentication to remember risk-based authn via [{}]", (Object)attributeName);
        authentication.update(newAuthn);
        return new AuthenticationRiskContingencyResponse(new Event((Object)this, id));
    }
}

