/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;

public class RiskAwareAuthenticationWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    static final String STATE_ID_BLOCKED_AUTHN = "riskyAuthenticationBlocked";

    public RiskAwareAuthenticationWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            ActionState submit = (ActionState)this.getState(flow, "realSubmit", ActionState.class);
            this.createTransitionForState((TransitionableState)submit, "blockedAuthentication", STATE_ID_BLOCKED_AUTHN);
            this.createViewState(flow, STATE_ID_BLOCKED_AUTHN, "adaptive-authn/casRiskAuthenticationBlockedView");
        }
    }
}

