/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.api.AuthenticationRiskContingencyResponse;
import org.apereo.cas.api.AuthenticationRiskEvaluator;
import org.apereo.cas.api.AuthenticationRiskMitigator;
import org.apereo.cas.api.AuthenticationRiskScore;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.events.authentication.adaptive.CasRiskBasedAuthenticationEvaluationStartedEvent;
import org.apereo.cas.support.events.authentication.adaptive.CasRiskBasedAuthenticationMitigationStartedEvent;
import org.apereo.cas.support.events.authentication.adaptive.CasRiskyAuthenticationDetectedEvent;
import org.apereo.cas.support.events.authentication.adaptive.CasRiskyAuthenticationMitigatedEvent;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.resolver.impl.AbstractCasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class RiskAwareAuthenticationWebflowEventResolver
extends AbstractCasWebflowEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RiskAwareAuthenticationWebflowEventResolver.class);
    private final AuthenticationRiskEvaluator authenticationRiskEvaluator;
    private final AuthenticationRiskMitigator authenticationRiskMitigator;

    public RiskAwareAuthenticationWebflowEventResolver(CasWebflowEventResolutionConfigurationContext context, AuthenticationRiskEvaluator authenticationRiskEvaluator, AuthenticationRiskMitigator authenticationRiskMitigator) {
        super(context);
        this.authenticationRiskEvaluator = authenticationRiskEvaluator;
        this.authenticationRiskMitigator = authenticationRiskMitigator;
    }

    public Set<Event> resolveInternal(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        RegisteredService service = WebUtils.getRegisteredService((RequestContext)context);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)context);
        if (service == null || authentication == null) {
            LOGGER.debug("No service or authentication is available to determine event for principal");
            return null;
        }
        return this.handlePossibleSuspiciousAttempt(request, authentication, service);
    }

    protected Set<Event> handlePossibleSuspiciousAttempt(HttpServletRequest request, Authentication authentication, RegisteredService service) {
        ConfigurableApplicationContext applicationContext = this.getConfigurationContext().getApplicationContext();
        applicationContext.publishEvent((ApplicationEvent)new CasRiskBasedAuthenticationEvaluationStartedEvent((Object)this, authentication, service));
        LOGGER.debug("Evaluating possible suspicious authentication attempt for [{}]", (Object)authentication.getPrincipal());
        AuthenticationRiskScore score = this.authenticationRiskEvaluator.eval(authentication, service, request);
        double threshold = this.getConfigurationContext().getCasProperties().getAuthn().getAdaptive().getRisk().getThreshold();
        if (score.isRiskGreaterThan(threshold)) {
            applicationContext.publishEvent((ApplicationEvent)new CasRiskyAuthenticationDetectedEvent((Object)this, authentication, service, (Object)score));
            LOGGER.debug("Calculated risk score [{}] for authentication request by [{}] is above the risk threshold [{}].", new Object[]{score.getScore(), authentication.getPrincipal(), threshold});
            applicationContext.publishEvent((ApplicationEvent)new CasRiskBasedAuthenticationMitigationStartedEvent((Object)this, authentication, service, (Object)score));
            AuthenticationRiskContingencyResponse res = this.authenticationRiskMitigator.mitigate(authentication, service, score, request);
            applicationContext.publishEvent((ApplicationEvent)new CasRiskyAuthenticationMitigatedEvent((Object)this, authentication, service, (Object)res));
            return CollectionUtils.wrapSet((Object)res.getResult());
        }
        LOGGER.debug("Authentication request for [{}] is below the risk threshold", (Object)authentication.getPrincipal());
        return null;
    }
}

