/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.couchdb.BaseCouchDbProperties;
import org.apereo.cas.couchdb.core.CouchDbConnectorFactory;
import org.apereo.cas.couchdb.events.EventCouchDbRepository;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.CasEventRepositoryFilter;
import org.apereo.cas.support.events.CouchDbCasEventRepository;
import org.ektorp.impl.ObjectMapperFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="couchDbEventsConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CouchDbEventsConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="defaultObjectMapperFactory")
    private ObjectProvider<ObjectMapperFactory> objectMapperFactory;

    @ConditionalOnMissingBean(name={"couchDbEventRepository"})
    @Bean
    @RefreshScope
    public EventCouchDbRepository couchDbEventRepository(@Qualifier(value="eventCouchDbFactory") CouchDbConnectorFactory eventCouchDbFactory) {
        EventCouchDbRepository repository = new EventCouchDbRepository(eventCouchDbFactory.getCouchDbConnector(), this.casProperties.getEvents().getCouchDb().isCreateIfNotExists());
        repository.initStandardDesignDocument();
        return repository;
    }

    @ConditionalOnMissingBean(name={"eventCouchDbFactory"})
    @Bean
    @RefreshScope
    public CouchDbConnectorFactory eventCouchDbFactory() {
        return new CouchDbConnectorFactory((BaseCouchDbProperties)this.casProperties.getEvents().getCouchDb(), (ObjectMapperFactory)this.objectMapperFactory.getObject());
    }

    @ConditionalOnMissingBean(name={"couchDbCasEventRepository"})
    @Bean
    @RefreshScope
    @Autowired
    public CasEventRepository casEventRepository(@Qualifier(value="couchDbEventRepository") EventCouchDbRepository eventCouchDbRepository, @Qualifier(value="couchDbEventRepositoryFilter") CasEventRepositoryFilter couchDbEventRepositoryFilter) {
        return new CouchDbCasEventRepository(couchDbEventRepositoryFilter, eventCouchDbRepository, this.casProperties.getEvents().getCouchDb().isAsynchronous());
    }

    @ConditionalOnMissingBean(name={"couchDbEventRepositoryFilter"})
    @Bean
    public CasEventRepositoryFilter couchDbEventRepositoryFilter() {
        return CasEventRepositoryFilter.noOp();
    }
}

