/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.couchdb.events;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apereo.cas.couchdb.events.CouchDbCasEvent;
import org.ektorp.ComplexKey;
import org.ektorp.CouchDbConnector;
import org.ektorp.ViewQuery;
import org.ektorp.support.CouchDbRepositorySupport;
import org.ektorp.support.GenerateView;
import org.ektorp.support.View;

@View(name="all", map="function(doc) { emit(doc._id, doc) }")
public class EventCouchDbRepository
extends CouchDbRepositorySupport<CouchDbCasEvent> {
    public EventCouchDbRepository(CouchDbConnector db, boolean createIfNotExists) {
        super(CouchDbCasEvent.class, db, createIfNotExists);
    }

    @GenerateView
    public List<CouchDbCasEvent> findByType(String type) {
        return this.queryView("by_type", type);
    }

    public List<CouchDbCasEvent> findByTypeSince(String type, ZonedDateTime dt) {
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        return this.findByType(type).stream().filter(event -> {
            ZonedDateTime eventDate = ZonedDateTime.parse(event.getCreationTime());
            return eventDate.isEqual(dt) || eventDate.isAfter(dt) && eventDate.isBefore(now);
        }).collect(Collectors.toList());
    }

    @View(name="by_type_for_principal_id", map="function(doc) { emit([doc.type, doc.principalId], doc) }")
    public Collection<CouchDbCasEvent> findByTypeForPrincipalId(String type, String principalId) {
        ViewQuery view = this.createQuery("by_type_for_principal_id").key((Object)ComplexKey.of((Object[])new Object[]{type, principalId}));
        return this.db.queryView(view, CouchDbCasEvent.class);
    }

    public Collection<CouchDbCasEvent> findByTypeForPrincipalSince(String type, String principalId, ZonedDateTime dt) {
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        return this.findByTypeForPrincipalId(type, principalId).stream().filter(event -> {
            ZonedDateTime eventDate = ZonedDateTime.parse(event.getCreationTime());
            return eventDate.isEqual(dt) || eventDate.isAfter(dt) && eventDate.isBefore(now);
        }).collect(Collectors.toList());
    }

    @GenerateView
    public Collection<CouchDbCasEvent> findByPrincipalId(String principalId) {
        return this.queryView("by_principalId", principalId);
    }

    public Collection<CouchDbCasEvent> findByPrincipalSince(String principalId, ZonedDateTime creationTime) {
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        return this.findByPrincipalId(principalId).stream().filter(event -> {
            ZonedDateTime eventDate = ZonedDateTime.parse(event.getCreationTime());
            return eventDate.isEqual(creationTime) || eventDate.isAfter(creationTime) && eventDate.isBefore(now);
        }).collect(Collectors.toList());
    }
}

