/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.events;

import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apereo.cas.couchdb.events.CouchDbCasEvent;
import org.apereo.cas.couchdb.events.EventCouchDbRepository;
import org.apereo.cas.support.events.CasEventRepositoryFilter;
import org.apereo.cas.support.events.dao.AbstractCasEventRepository;
import org.apereo.cas.support.events.dao.CasEvent;
import org.springframework.beans.factory.DisposableBean;

public class CouchDbCasEventRepository
extends AbstractCasEventRepository
implements DisposableBean {
    private final EventCouchDbRepository couchDb;
    private final boolean asynchronous;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(r -> new Thread(r, "CouchDbCasEventRepositoryThread"));

    public CouchDbCasEventRepository(CasEventRepositoryFilter eventRepositoryFilter, EventCouchDbRepository couchDb, boolean asynchronous) {
        super(eventRepositoryFilter);
        this.couchDb = couchDb;
        this.asynchronous = asynchronous;
    }

    private static Collection<CasEvent> castEvents(Collection<CouchDbCasEvent> events) {
        return events.stream().map(event -> event).collect(Collectors.toSet());
    }

    public Collection<? extends CasEvent> load() {
        return this.couchDb.getAll();
    }

    public Collection<CasEvent> getEventsOfTypeForPrincipal(String type, String principal) {
        return CouchDbCasEventRepository.castEvents(this.couchDb.findByTypeForPrincipalId(type, principal));
    }

    public Collection<CasEvent> getEventsOfTypeForPrincipal(String type, String principal, ZonedDateTime dateTime) {
        return CouchDbCasEventRepository.castEvents(this.couchDb.findByTypeForPrincipalSince(type, principal, dateTime));
    }

    public Collection<CasEvent> getEventsOfType(String type) {
        return CouchDbCasEventRepository.castEvents(this.couchDb.findByType(type));
    }

    public Collection<CasEvent> getEventsOfType(String type, ZonedDateTime dateTime) {
        return CouchDbCasEventRepository.castEvents(this.couchDb.findByTypeSince(type, dateTime));
    }

    public Collection<CasEvent> getEventsForPrincipal(String id) {
        return CouchDbCasEventRepository.castEvents(this.couchDb.findByPrincipalId(id));
    }

    public Collection<CasEvent> getEventsForPrincipal(String id, ZonedDateTime dateTime) {
        return CouchDbCasEventRepository.castEvents(this.couchDb.findByPrincipalSince(id, dateTime));
    }

    public void saveInternal(CasEvent event) {
        if (this.asynchronous) {
            this.executorService.execute(() -> this.couchDb.add((Object)new CouchDbCasEvent(event)));
        } else {
            this.couchDb.add((Object)new CouchDbCasEvent(event));
        }
    }

    public void destroy() {
        this.executorService.shutdown();
    }
}

