/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.events.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.time.ZonedDateTime;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.jpa.JpaBeanFactory;
import org.apereo.cas.support.events.CasEventRepositoryFilter;
import org.apereo.cas.support.events.dao.AbstractCasEventRepository;
import org.apereo.cas.support.events.dao.CasEvent;
import org.apereo.cas.support.events.jpa.JpaCasEvent;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@EnableTransactionManagement(proxyTargetClass=false)
@Transactional(transactionManager="transactionManagerEvents")
public class JpaCasEventRepository
extends AbstractCasEventRepository {
    private static final String SELECT_QUERY = "SELECT r from JpaCasEvent r ";
    private final PlatformTransactionManager transactionManager;
    private final CasConfigurationProperties casProperties;
    private final JpaBeanFactory jpaBeanFactory;
    @PersistenceContext(unitName="jpaEventRegistryContext")
    private EntityManager entityManager;

    public JpaCasEventRepository(CasEventRepositoryFilter eventRepositoryFilter, PlatformTransactionManager transactionManager, CasConfigurationProperties casProperties, JpaBeanFactory jpaBeanFactory) {
        super(eventRepositoryFilter);
        this.transactionManager = transactionManager;
        this.casProperties = casProperties;
        this.jpaBeanFactory = jpaBeanFactory;
    }

    public void removeAll() {
        this.entityManager.createQuery("DELETE FROM JpaCasEvent e").executeUpdate();
    }

    @Transactional(readOnly=true)
    public Stream<? extends CasEvent> load() {
        TypedQuery query = this.entityManager.createQuery(SELECT_QUERY.trim(), JpaCasEvent.class);
        return this.jpaBeanFactory.streamQuery((Query)query).map(JpaCasEvent.class::cast);
    }

    @Transactional(readOnly=true)
    public Stream<? extends CasEvent> load(ZonedDateTime dateTime) {
        String sql = SELECT_QUERY.concat("where r.creationTime >= :creationTime");
        TypedQuery query = this.entityManager.createQuery(sql, JpaCasEvent.class).setParameter("creationTime", (Object)dateTime.toString());
        query.setLockMode(LockModeType.NONE);
        return this.jpaBeanFactory.streamQuery((Query)query).map(JpaCasEvent.class::cast);
    }

    @Transactional(readOnly=true)
    public Stream<? extends CasEvent> getEventsOfTypeForPrincipal(String type, String principal) {
        String sql = SELECT_QUERY.concat("where r.type = :type and r.principalId = :principalId");
        TypedQuery query = this.entityManager.createQuery(sql, JpaCasEvent.class).setParameter("type", (Object)type).setParameter("principalId", (Object)principal);
        return this.jpaBeanFactory.streamQuery((Query)query).map(JpaCasEvent.class::cast);
    }

    @Transactional(readOnly=true)
    public Stream<? extends CasEvent> getEventsOfTypeForPrincipal(String type, String principal, ZonedDateTime dateTime) {
        String sql = SELECT_QUERY.concat("where r.type = :type and r.creationTime >= :creationTime and r.principalId = :principalId");
        TypedQuery query = this.entityManager.createQuery(sql, JpaCasEvent.class).setParameter("type", (Object)type).setParameter("principalId", (Object)principal).setParameter("creationTime", (Object)dateTime.toString());
        return this.jpaBeanFactory.streamQuery((Query)query).map(JpaCasEvent.class::cast);
    }

    @Transactional(readOnly=true)
    public Stream<? extends CasEvent> getEventsOfType(String type) {
        TypedQuery query = this.entityManager.createQuery(SELECT_QUERY.concat("where r.type = :type"), JpaCasEvent.class).setParameter("type", (Object)type);
        return this.jpaBeanFactory.streamQuery((Query)query).map(JpaCasEvent.class::cast);
    }

    @Transactional(readOnly=true)
    public Stream<? extends CasEvent> getEventsOfType(String type, ZonedDateTime dateTime) {
        String sql = SELECT_QUERY.concat("where r.type = :type and r.creationTime >= :creationTime");
        TypedQuery query = this.entityManager.createQuery(sql, JpaCasEvent.class).setParameter("type", (Object)type).setParameter("creationTime", (Object)dateTime.toString());
        return this.jpaBeanFactory.streamQuery((Query)query).map(JpaCasEvent.class::cast);
    }

    @Transactional(readOnly=true)
    public Stream<? extends CasEvent> getEventsForPrincipal(String id) {
        String sql = SELECT_QUERY.concat("where r.principalId = :principalId");
        TypedQuery query = this.entityManager.createQuery(sql, JpaCasEvent.class).setParameter("principalId", (Object)id);
        return this.jpaBeanFactory.streamQuery((Query)query).map(JpaCasEvent.class::cast);
    }

    @Transactional(readOnly=true)
    public Stream<? extends CasEvent> getEventsForPrincipal(String id, ZonedDateTime dateTime) {
        String sql = SELECT_QUERY.concat("where r.principalId = :principalId and r.creationTime >= :creationTime");
        TypedQuery query = this.entityManager.createQuery(sql, JpaCasEvent.class).setParameter("principalId", (Object)id).setParameter("creationTime", (Object)dateTime.toString());
        return this.jpaBeanFactory.streamQuery((Query)query).map(JpaCasEvent.class::cast);
    }

    public CasEvent saveInternal(CasEvent event) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        return (CasEvent)transactionTemplate.execute(ts -> {
            JpaCasEvent jpaEvent = new JpaCasEvent();
            jpaEvent.setId(event.getId());
            jpaEvent.setCreationTime(event.getCreationTime());
            jpaEvent.setPrincipalId(event.getPrincipalId());
            jpaEvent.setProperties(event.getProperties());
            jpaEvent.setType(event.getType());
            return (CasEvent)this.entityManager.merge((Object)jpaEvent);
        });
    }

    @Generated
    public String toString() {
        return "JpaCasEventRepository(transactionManager=" + String.valueOf(this.transactionManager) + ", casProperties=" + String.valueOf(this.casProperties) + ", jpaBeanFactory=" + String.valueOf(this.jpaBeanFactory) + ", entityManager=" + String.valueOf(this.entityManager) + ")";
    }
}

