/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import jakarta.persistence.EntityManagerFactory;
import java.util.Set;
import javax.sql.DataSource;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigurationContext;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.jpa.JpaBeanFactory;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.CasEventRepositoryFilter;
import org.apereo.cas.support.events.jpa.JpaCasEvent;
import org.apereo.cas.support.events.jpa.JpaCasEventRepository;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.jooq.lambda.Unchecked;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement(proxyTargetClass=false)
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Events}, module="jpa")
@AutoConfiguration
@Lazy(value=false)
public class CasJpaEventsAutoConfiguration {
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.events.jpa.enabled").isTrue().evenIfMissing();

    @Configuration(value="JpaEventsRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class JpaEventsRepositoryConfiguration {
        JpaEventsRepositoryConfiguration() {
        }

        @ConditionalOnMissingBean(name={"jpaEventRepositoryFilter"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasEventRepositoryFilter jpaEventRepositoryFilter() {
            return CasEventRepositoryFilter.noOp();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasEventRepository casEventRepository(@Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory, CasConfigurationProperties casProperties, @Qualifier(value="transactionManagerEvents") PlatformTransactionManager transactionManager, @Qualifier(value="jpaEventRepositoryFilter") CasEventRepositoryFilter jpaEventRepositoryFilter) {
            return new JpaCasEventRepository(jpaEventRepositoryFilter, transactionManager, casProperties, jpaBeanFactory);
        }
    }

    @Configuration(value="JpaEventsTransactionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class JpaEventsTransactionConfiguration {
        JpaEventsTransactionConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PlatformTransactionManager transactionManagerEvents(@Qualifier(value="eventsEntityManagerFactory") EntityManagerFactory emf) {
            JpaTransactionManager mgmr = new JpaTransactionManager();
            mgmr.setEntityManagerFactory(emf);
            return mgmr;
        }
    }

    @Configuration(value="JpaEventsEntityConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class JpaEventsEntityConfiguration {
        JpaEventsEntityConfiguration() {
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public JpaVendorAdapter jpaEventVendorAdapter(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) {
            return (JpaVendorAdapter)BeanSupplier.of(JpaVendorAdapter.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> jpaBeanFactory.newJpaVendorAdapter(casProperties.getJdbc())).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<String> jpaEventPackagesToScan(ConfigurableApplicationContext applicationContext) {
            return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> BeanContainer.of((Set)CollectionUtils.wrapSet((Object)JpaCasEvent.class.getPackage().getName()))).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public FactoryBean<EntityManagerFactory> eventsEntityManagerFactory(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="jpaEventVendorAdapter") JpaVendorAdapter jpaEventVendorAdapter, @Qualifier(value="dataSourceEvent") DataSource dataSourceEvent, @Qualifier(value="jpaEventPackagesToScan") BeanContainer<String> jpaEventPackagesToScan, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) {
            return (FactoryBean)BeanSupplier.of(FactoryBean.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(Unchecked.supplier(() -> {
                JpaConfigurationContext ctx = JpaConfigurationContext.builder().jpaVendorAdapter(jpaEventVendorAdapter).persistenceUnitName("jpaEventRegistryContext").dataSource(dataSourceEvent).packagesToScan(jpaEventPackagesToScan.toSet()).build();
                return jpaBeanFactory.newEntityManagerFactoryBean(ctx, (AbstractJpaProperties)casProperties.getEvents().getJpa());
            })).otherwiseProxy().get();
        }
    }

    @Configuration(value="JpaEventsDataConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class JpaEventsDataConfiguration {
        JpaEventsDataConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"dataSourceEvent"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DataSource dataSourceEvent(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (DataSource)BeanSupplier.of(DataSource.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> JpaBeans.newDataSource((AbstractJpaProperties)casProperties.getEvents().getJpa())).otherwiseProxy().get();
        }
    }
}

