/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import java.util.Collections;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apereo.cas.gauth.credential.BaseLdapGoogleAuthenticatorTokenCredentialRepositoryTests;
import org.apereo.cas.util.junit.EnabledIfListeningOnPort;
import org.junit.jupiter.api.Tag;
import org.ldaptive.BindConnectionInitializer;
import org.ldaptive.Credential;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootTest(classes={BaseLdapGoogleAuthenticatorTokenCredentialRepositoryTests.SharedTestConfiguration.class}, properties={"cas.authn.mfa.gauth.ldap.account-attribute-name=streetAddress", "cas.authn.mfa.gauth.ldap.ldap-url=ldaps://localhost:10636", "cas.authn.mfa.gauth.ldap.bind-dn=CN=admin,CN=Users,DC=cas,DC=example,DC=org", "cas.authn.mfa.gauth.ldap.bind-credential=P@ssw0rd", "cas.authn.mfa.gauth.ldap.base-dn=CN=Users,DC=cas,DC=example,DC=org", "cas.authn.mfa.gauth.ldap.search-filter=cn={user}", "cas.authn.mfa.gauth.ldap.trust-store=file:/tmp/adcacerts.jks", "cas.authn.mfa.gauth.ldap.trust-store-type=JKS", "cas.authn.mfa.gauth.ldap.trust-store-password=changeit", "cas.authn.mfa.gauth.ldap.min-pool-size=0", "cas.authn.mfa.gauth.ldap.hostname-verifier=DEFAULT", "cas.authn.mfa.gauth.crypto.enabled=true"})
@EnableScheduling
@Tag(value="ActiveDirectory")
@EnabledIfListeningOnPort(port={10636})
class ActiveDirectoryGoogleAuthenticatorTokenCredentialRepositoryTests
extends BaseLdapGoogleAuthenticatorTokenCredentialRepositoryTests {
    ActiveDirectoryGoogleAuthenticatorTokenCredentialRepositoryTests() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getUsernameUnderTest() throws Exception {
        String uid = "aham";
        BindConnectionInitializer bindInit = new BindConnectionInitializer("CN=admin,CN=Users,DC=cas,DC=example,DC=org", new Credential("P@ssw0rd"));
        SSLUtil sslUtil = new SSLUtil(null, (TrustManager)new TrustAllTrustManager());
        SSLSocketFactory socketFactory = sslUtil.createSSLSocketFactory();
        LDAPConnection connection = new LDAPConnection((SocketFactory)socketFactory, "localhost", 10636, bindInit.getBindDn(), bindInit.getBindCredential().getString());
        try {
            Modification mod = new Modification(ModificationType.REPLACE, "streetAddress", " ");
            connection.modify(String.format("CN=%s,CN=Users,DC=cas,DC=example,DC=org", "aham"), mod);
            String string = "aham";
            return string;
        }
        finally {
            if (Collections.singletonList(connection).get(0) != null) {
                connection.close();
            }
        }
    }
}

