/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import com.unboundid.ldap.sdk.LDAPConnection;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apereo.cas.adaptors.ldap.LdapIntegrationTestsOperations;
import org.apereo.cas.gauth.credential.BaseLdapGoogleAuthenticatorTokenCredentialRepositoryTests;
import org.apereo.cas.util.junit.EnabledIfListeningOnPort;
import org.junit.jupiter.api.Tag;
import org.ldaptive.BindConnectionInitializer;
import org.ldaptive.Credential;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootTest(classes={BaseLdapGoogleAuthenticatorTokenCredentialRepositoryTests.SharedTestConfiguration.class}, properties={"cas.authn.mfa.gauth.ldap.ldap-url=ldap://localhost:11389", "cas.authn.mfa.gauth.ldap.base-dn=ou=people,dc=example,dc=org", "cas.authn.mfa.gauth.ldap.search-filter=cn={0}", "cas.authn.mfa.gauth.ldap.account-attribute-name=description", "cas.authn.mfa.gauth.ldap.bind-dn=cn=admin,dc=example,dc=org", "cas.authn.mfa.gauth.ldap.bind-credential=P@ssw0rd", "cas.authn.mfa.gauth.ldap.trust-manager=ANY", "cas.authn.mfa.gauth.crypto.enabled=true"})
@EnableScheduling
@Tag(value="LdapRepository")
@EnabledIfListeningOnPort(port={11636})
class OpenLdapGoogleAuthenticatorTokenCredentialRepositoryTests
extends BaseLdapGoogleAuthenticatorTokenCredentialRepositoryTests {
    OpenLdapGoogleAuthenticatorTokenCredentialRepositoryTests() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getUsernameUnderTest() throws Exception {
        String uid = super.getUsernameUnderTest();
        BindConnectionInitializer bindInit = new BindConnectionInitializer("cn=admin,dc=example,dc=org", new Credential("P@ssw0rd"));
        LDAPConnection connection = new LDAPConnection("localhost", 11389, bindInit.getBindDn(), bindInit.getBindCredential().getString());
        try {
            ByteArrayInputStream rs = new ByteArrayInputStream(this.getLdif(uid).getBytes(StandardCharsets.UTF_8));
            LdapIntegrationTestsOperations.populateEntries((LDAPConnection)connection, (InputStream)rs, (String)"ou=people,dc=example,dc=org", (BindConnectionInitializer)bindInit);
            String string = uid;
            return string;
        }
        finally {
            if (Collections.singletonList(connection).get(0) != null) {
                connection.close();
            }
        }
    }

    protected String getLdif(String user) {
        String baseDn = this.getCasProperties().getAuthn().getMfa().getGauth().getLdap().getBaseDn();
        return String.format("dn: cn=%s,%s%nobjectClass: top%nobjectClass: person%nobjectClass: organizationalPerson%nobjectClass: inetOrgPerson%ncn: %s%nuserPassword: 123456%nsn: %s%nuid: %s%n", user, baseDn, user, user, user);
    }
}

