/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import com.unboundid.ldap.sdk.LDAPConnection;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apereo.cas.adaptors.ldap.LdapIntegrationTestsOperations;
import org.apereo.cas.gauth.credential.BaseLdapGoogleAuthenticatorTokenCredentialRepositoryTests;
import org.apereo.cas.util.junit.EnabledIfListeningOnPort;
import org.junit.jupiter.api.Tag;
import org.ldaptive.BindConnectionInitializer;
import org.ldaptive.Credential;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootTest(classes={BaseLdapGoogleAuthenticatorTokenCredentialRepositoryTests.SharedTestConfiguration.class}, properties={"cas.authn.mfa.gauth.ldap.ldap-url=ldap://localhost:10389", "cas.authn.mfa.gauth.ldap.base-dn=ou=people,dc=example,dc=org", "cas.authn.mfa.gauth.ldap.search-filter=cn={0}", "cas.authn.mfa.gauth.ldap.account-attribute-name=description", "cas.authn.mfa.gauth.ldap.bind-dn=cn=Directory Manager", "cas.authn.mfa.gauth.ldap.bind-credential=password", "cas.authn.mfa.gauth.crypto.enabled=true"})
@EnableScheduling
@Tag(value="LdapRepository")
@EnabledIfListeningOnPort(port={10389})
class LdapGoogleAuthenticatorTokenCredentialRepositoryTests
extends BaseLdapGoogleAuthenticatorTokenCredentialRepositoryTests {
    LdapGoogleAuthenticatorTokenCredentialRepositoryTests() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getUsernameUnderTest() throws Exception {
        String uid = super.getUsernameUnderTest();
        LDAPConnection c = new LDAPConnection("localhost", 10389, "cn=Directory Manager", "password");
        try {
            BindConnectionInitializer bindInit = new BindConnectionInitializer("cn=Directory Manager", new Credential("password"));
            ByteArrayInputStream rs = new ByteArrayInputStream(this.getLdif(uid).getBytes(StandardCharsets.UTF_8));
            LdapIntegrationTestsOperations.populateEntries((LDAPConnection)c, (InputStream)rs, (String)"ou=people,dc=example,dc=org", (BindConnectionInitializer)bindInit);
            String string = uid;
            return string;
        }
        finally {
            if (Collections.singletonList(c).get(0) != null) {
                c.close();
            }
        }
    }

    protected String getLdif(String user) {
        String baseDn = this.getCasProperties().getAuthn().getMfa().getGauth().getLdap().getBaseDn();
        return String.format("dn: cn=%s,%s%nobjectClass: organizationalRole%nobjectClass: person%nobjectClass: account%ncn: %s%nuserPassword: 123456%nsn: %s%nuid: %s%n", user, baseDn, user, user, user);
    }
}

