/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.warrenstrange.googleauth.IGoogleAuthenticator;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.MongoDbGoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.configuration.model.support.mongo.BaseMongoDbProperties;
import org.apereo.cas.configuration.support.CasFeatureModule;
import org.apereo.cas.gauth.credential.MongoDbGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.gauth.token.GoogleAuthenticatorMongoDbTokenRepository;
import org.apereo.cas.mongo.CasMongoOperations;
import org.apereo.cas.mongo.MongoDbConnectionFactory;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.otp.repository.token.OneTimeTokenRepository;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.boot.ConditionalOnFeature;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement(proxyTargetClass=false)
@EnableScheduling
@Configuration(value="GoogleAuthenticatorMongoDbConfiguration", proxyBeanMethods=false)
@ConditionalOnFeature(feature=CasFeatureModule.FeatureCatalog.GoogleAuthenticator, module="mongo")
public class GoogleAuthenticatorMongoDbConfiguration {
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public PersistenceExceptionTranslationPostProcessor persistenceExceptionTranslationPostProcessor() {
        return new PersistenceExceptionTranslationPostProcessor();
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public MongoOperations mongoDbGoogleAuthenticatorTemplate(CasConfigurationProperties casProperties, @Qualifier(value="casSslContext") CasSSLContext casSslContext) {
        MongoDbGoogleAuthenticatorMultifactorProperties mongo = casProperties.getAuthn().getMfa().getGauth().getMongo();
        MongoDbConnectionFactory factory = new MongoDbConnectionFactory(casSslContext.getSslContext());
        CasMongoOperations mongoTemplate = factory.buildMongoTemplate((BaseMongoDbProperties)mongo);
        MongoDbConnectionFactory.createCollection((MongoOperations)mongoTemplate, (String)mongo.getTokenCollection(), (boolean)mongo.isDropCollection());
        return mongoTemplate;
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry(@Qualifier(value="googleAuthenticatorInstance") IGoogleAuthenticator googleAuthenticatorInstance, @Qualifier(value="googleAuthenticatorAccountCipherExecutor") CipherExecutor googleAuthenticatorAccountCipherExecutor, @Qualifier(value="googleAuthenticatorScratchCodesCipherExecutor") CipherExecutor googleAuthenticatorScratchCodesCipherExecutor, CasConfigurationProperties casProperties, @Qualifier(value="mongoDbGoogleAuthenticatorTemplate") MongoOperations mongoDbGoogleAuthenticatorTemplate) {
        MongoDbGoogleAuthenticatorMultifactorProperties mongo = casProperties.getAuthn().getMfa().getGauth().getMongo();
        return new MongoDbGoogleAuthenticatorTokenCredentialRepository(googleAuthenticatorInstance, mongoDbGoogleAuthenticatorTemplate, mongo.getCollection(), (CipherExecutor<String, String>)googleAuthenticatorAccountCipherExecutor, (CipherExecutor<Number, Number>)googleAuthenticatorScratchCodesCipherExecutor);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public OneTimeTokenRepository oneTimeTokenAuthenticatorTokenRepository(CasConfigurationProperties casProperties, @Qualifier(value="mongoDbGoogleAuthenticatorTemplate") MongoOperations mongoDbGoogleAuthenticatorTemplate) {
        MongoDbGoogleAuthenticatorMultifactorProperties mongo = casProperties.getAuthn().getMfa().getGauth().getMongo();
        return new GoogleAuthenticatorMongoDbTokenRepository(mongoDbGoogleAuthenticatorTemplate, mongo.getTokenCollection(), casProperties.getAuthn().getMfa().getGauth().getCore().getTimeStepSize());
    }
}

