/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import com.warrenstrange.googleauth.IGoogleAuthenticator;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.gauth.credential.BaseGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorAccount;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MongoDbGoogleAuthenticatorTokenCredentialRepository
extends BaseGoogleAuthenticatorTokenCredentialRepository {
    private final MongoOperations mongoTemplate;
    private final String collectionName;

    public MongoDbGoogleAuthenticatorTokenCredentialRepository(IGoogleAuthenticator googleAuthenticator, MongoOperations mongoTemplate, String collectionName, CipherExecutor<String, String> tokenCredentialCipher, CipherExecutor<Number, Number> scratchCodesCipher) {
        super(tokenCredentialCipher, scratchCodesCipher, googleAuthenticator);
        this.mongoTemplate = mongoTemplate;
        this.collectionName = collectionName;
    }

    public OneTimeTokenAccount get(long id) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)id)).collation(Collation.of((Locale)Locale.ENGLISH).strength((Collation.ComparisonLevel)Collation.ComparisonLevel.primary()));
        GoogleAuthenticatorAccount r = (GoogleAuthenticatorAccount)this.mongoTemplate.findOne(query, GoogleAuthenticatorAccount.class, this.collectionName);
        return r != null ? this.decode((OneTimeTokenAccount)r) : null;
    }

    public OneTimeTokenAccount get(String username, long id) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"username").is((Object)username.trim()).and("id").is((Object)id)).collation(Collation.of((Locale)Locale.ENGLISH).strength((Collation.ComparisonLevel)Collation.ComparisonLevel.primary()));
        GoogleAuthenticatorAccount r = (GoogleAuthenticatorAccount)this.mongoTemplate.findOne(query, GoogleAuthenticatorAccount.class, this.collectionName);
        return r != null ? this.decode((OneTimeTokenAccount)r) : null;
    }

    public Collection<? extends OneTimeTokenAccount> get(String username) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"username").is((Object)username.trim())).collation(Collation.of((Locale)Locale.ENGLISH).strength((Collation.ComparisonLevel)Collation.ComparisonLevel.primary()));
        List r = this.mongoTemplate.find(query, GoogleAuthenticatorAccount.class, this.collectionName);
        return this.decode(r);
    }

    public Collection<? extends OneTimeTokenAccount> load() {
        List r = this.mongoTemplate.findAll(GoogleAuthenticatorAccount.class, this.collectionName);
        return r.stream().map(arg_0 -> ((MongoDbGoogleAuthenticatorTokenCredentialRepository)this).decode(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public OneTimeTokenAccount save(OneTimeTokenAccount account) {
        return this.update(account);
    }

    public OneTimeTokenAccount update(OneTimeTokenAccount account) {
        OneTimeTokenAccount encodedAccount = this.encode(account);
        this.mongoTemplate.save((Object)encodedAccount, this.collectionName);
        return encodedAccount;
    }

    public void deleteAll() {
        this.mongoTemplate.remove(new Query(), GoogleAuthenticatorAccount.class, this.collectionName);
    }

    public void delete(String username) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"username").is((Object)username.trim())).collation(Collation.of((Locale)Locale.ENGLISH).strength((Collation.ComparisonLevel)Collation.ComparisonLevel.primary()));
        this.mongoTemplate.remove(query, GoogleAuthenticatorAccount.class, this.collectionName);
    }

    public void delete(long id) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)id)).collation(Collation.of((Locale)Locale.ENGLISH).strength((Collation.ComparisonLevel)Collation.ComparisonLevel.primary()));
        this.mongoTemplate.remove(query, GoogleAuthenticatorAccount.class, this.collectionName);
    }

    public long count() {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"username").exists(true));
        return this.mongoTemplate.count(query, GoogleAuthenticatorAccount.class, this.collectionName);
    }

    public long count(String username) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"username").is((Object)username.trim())).collation(Collation.of((Locale)Locale.ENGLISH).strength((Collation.ComparisonLevel)Collation.ComparisonLevel.primary()));
        return this.mongoTemplate.count(query, GoogleAuthenticatorAccount.class, this.collectionName);
    }

    @Generated
    public String toString() {
        return "MongoDbGoogleAuthenticatorTokenCredentialRepository(mongoTemplate=" + this.mongoTemplate + ", collectionName=" + this.collectionName + ")";
    }

    @Generated
    public MongoOperations getMongoTemplate() {
        return this.mongoTemplate;
    }

    @Generated
    public String getCollectionName() {
        return this.collectionName;
    }
}

