/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.token;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Locale;
import lombok.Generated;
import org.apereo.cas.gauth.token.GoogleAuthenticatorToken;
import org.apereo.cas.otp.repository.token.BaseOneTimeTokenRepository;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class GoogleAuthenticatorMongoDbTokenRepository
extends BaseOneTimeTokenRepository<GoogleAuthenticatorToken> {
    private final MongoOperations mongoTemplate;
    private final String collectionName;
    private final long expireTokensInSeconds;

    public void store(GoogleAuthenticatorToken token) {
        this.mongoTemplate.save((Object)token, this.collectionName);
    }

    public GoogleAuthenticatorToken get(String uid, Integer otp) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)uid.trim()).and("token").is((Object)otp)).collation(Collation.of((Locale)Locale.ENGLISH).strength((Collation.ComparisonLevel)Collation.ComparisonLevel.primary()));
        return (GoogleAuthenticatorToken)this.mongoTemplate.findOne(query, GoogleAuthenticatorToken.class, this.collectionName);
    }

    public void remove(String uid, Integer otp) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)uid).and("token").is((Object)otp)).collation(Collation.of((Locale)Locale.ENGLISH).strength((Collation.ComparisonLevel)Collation.ComparisonLevel.primary()));
        this.mongoTemplate.remove(query, GoogleAuthenticatorToken.class, this.collectionName);
    }

    public void remove(String uid) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)uid.trim())).collation(Collation.of((Locale)Locale.ENGLISH).strength((Collation.ComparisonLevel)Collation.ComparisonLevel.primary()));
        this.mongoTemplate.remove(query, GoogleAuthenticatorToken.class, this.collectionName);
    }

    public void remove(Integer otp) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"token").is((Object)otp)).collation(Collation.of((Locale)Locale.ENGLISH).strength((Collation.ComparisonLevel)Collation.ComparisonLevel.primary()));
        this.mongoTemplate.remove(query, GoogleAuthenticatorToken.class, this.collectionName);
    }

    public void removeAll() {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").exists(true));
        this.mongoTemplate.remove(query, GoogleAuthenticatorToken.class, this.collectionName);
    }

    public long count(String uid) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)uid.trim())).collation(Collation.of((Locale)Locale.ENGLISH).strength((Collation.ComparisonLevel)Collation.ComparisonLevel.primary()));
        return this.mongoTemplate.count(query, GoogleAuthenticatorToken.class, this.collectionName);
    }

    public long count() {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").exists(true));
        return this.mongoTemplate.count(query, GoogleAuthenticatorToken.class, this.collectionName);
    }

    protected void cleanInternal() {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"issuedDateTime").gte((Object)LocalDateTime.now(ZoneId.systemDefault()).minusSeconds(this.expireTokensInSeconds)));
        this.mongoTemplate.remove(query, GoogleAuthenticatorToken.class, this.collectionName);
    }

    @Generated
    public GoogleAuthenticatorMongoDbTokenRepository(MongoOperations mongoTemplate, String collectionName, long expireTokensInSeconds) {
        this.mongoTemplate = mongoTemplate;
        this.collectionName = collectionName;
        this.expireTokensInSeconds = expireTokensInSeconds;
    }
}

