/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import com.warrenstrange.googleauth.IGoogleAuthenticator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.NoResultException;
import lombok.Generated;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.gauth.credential.BaseGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorAccount;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisGoogleAuthenticatorTokenCredentialRepository
extends BaseGoogleAuthenticatorTokenCredentialRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisGoogleAuthenticatorTokenCredentialRepository.class);
    private static final String KEY_SEPARATOR = ":";
    private static final String CAS_PREFIX = RedisGoogleAuthenticatorTokenCredentialRepository.class.getSimpleName();
    private final RedisTemplate template;

    public RedisGoogleAuthenticatorTokenCredentialRepository(IGoogleAuthenticator googleAuthenticator, RedisTemplate template, CipherExecutor<String, String> tokenCredentialCipher) {
        super(tokenCredentialCipher, googleAuthenticator);
        this.template = template;
    }

    public OneTimeTokenAccount get(String username) {
        try {
            String redisKey = RedisGoogleAuthenticatorTokenCredentialRepository.getGoogleAuthenticatorRedisKey(username);
            BoundValueOperations ops = this.template.boundValueOps((Object)redisKey);
            OneTimeTokenAccount r = (OneTimeTokenAccount)ops.get();
            if (r != null) {
                return this.decode(r);
            }
        }
        catch (NoResultException e) {
            LOGGER.debug("No record could be found for google authenticator id [{}]", (Object)username);
        }
        return null;
    }

    public Collection<? extends OneTimeTokenAccount> load() {
        try {
            return this.getGoogleAuthenticatorTokenKeys().stream().map(redisKey -> this.template.boundValueOps(redisKey).get()).filter(Objects::nonNull).map(r -> (OneTimeTokenAccount)r).map(arg_0 -> ((RedisGoogleAuthenticatorTokenCredentialRepository)this).decode(arg_0)).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error("No record could be found for google authenticator", (Throwable)e);
            return new ArrayList(0);
        }
    }

    public void save(String userName, String secretKey, int validationCode, List<Integer> scratchCodes) {
        GoogleAuthenticatorAccount account = new GoogleAuthenticatorAccount(userName, secretKey, validationCode, scratchCodes);
        this.update((OneTimeTokenAccount)account);
    }

    public OneTimeTokenAccount update(OneTimeTokenAccount account) {
        OneTimeTokenAccount encodedAccount = this.encode(account);
        String redisKey = RedisGoogleAuthenticatorTokenCredentialRepository.getGoogleAuthenticatorRedisKey(account.getUsername());
        LOGGER.trace("Saving [{}] using key [{}]", (Object)encodedAccount, (Object)redisKey);
        BoundValueOperations ops = this.template.boundValueOps((Object)redisKey);
        ops.set((Object)encodedAccount);
        return encodedAccount;
    }

    public void deleteAll() {
        try {
            Set<String> redisKey = this.getGoogleAuthenticatorTokenKeys();
            LOGGER.trace("Deleting tokens using key [{}]", redisKey);
            this.template.delete(redisKey);
            LOGGER.trace("Deleted tokens");
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void delete(String username) {
        try {
            Set<String> redisKey = this.getGoogleAuthenticatorTokenKeys(username);
            LOGGER.trace("Deleting tokens using key [{}]", redisKey);
            this.template.delete(redisKey);
            LOGGER.trace("Deleted tokens");
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    public long count() {
        try {
            Set<String> keys = this.getGoogleAuthenticatorTokenKeys();
            return keys.size();
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    private static String getGoogleAuthenticatorRedisKey(String username) {
        return CAS_PREFIX + KEY_SEPARATOR + username;
    }

    private Set<String> getGoogleAuthenticatorTokenKeys(String username) {
        String key = CAS_PREFIX + KEY_SEPARATOR + username;
        LOGGER.trace("Fetching Google Authenticator records based on key [{}]", (Object)key);
        return this.template.keys((Object)key);
    }

    private Set<String> getGoogleAuthenticatorTokenKeys() {
        String key = CAS_PREFIX + ":*";
        LOGGER.trace("Fetching Google Authenticator records based on key [{}]", (Object)key);
        return this.template.keys((Object)key);
    }

    @Generated
    public String toString() {
        return "RedisGoogleAuthenticatorTokenCredentialRepository(template=" + this.template + ")";
    }

    @Generated
    public RedisTemplate getTemplate() {
        return this.template;
    }
}

