/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.token;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.persistence.NoResultException;
import lombok.Generated;
import org.apereo.cas.authentication.OneTimeToken;
import org.apereo.cas.gauth.token.GoogleAuthenticatorToken;
import org.apereo.cas.otp.repository.token.BaseOneTimeTokenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;

public class GoogleAuthenticatorRedisTokenRepository
extends BaseOneTimeTokenRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleAuthenticatorRedisTokenRepository.class);
    private static final String KEY_SEPARATOR = ":";
    private static final String CAS_PREFIX = GoogleAuthenticatorRedisTokenRepository.class.getSimpleName();
    private final RedisTemplate<String, GoogleAuthenticatorToken> template;
    private final long expireTokensInSeconds;

    public void store(OneTimeToken token) {
        GoogleAuthenticatorToken gauthToken = (GoogleAuthenticatorToken)token;
        String redisKey = GoogleAuthenticatorRedisTokenRepository.getGoogleAuthenticatorTokenRedisKey(gauthToken);
        LOGGER.trace("Saving token [{}] using key [{}]", (Object)token, (Object)redisKey);
        BoundValueOperations ops = this.template.boundValueOps((Object)redisKey);
        ops.set((Object)gauthToken);
        ops.expire(this.expireTokensInSeconds, TimeUnit.SECONDS);
        LOGGER.trace("Saved token [{}]", (Object)token);
    }

    public GoogleAuthenticatorToken get(String uid, Integer otp) {
        try {
            String redisKey = GoogleAuthenticatorRedisTokenRepository.getGoogleAuthenticatorTokenRedisKey(uid, otp);
            BoundValueOperations ops = this.template.boundValueOps((Object)redisKey);
            LOGGER.trace("Locating token by identifier [{}] using key [{}]", (Object)uid, (Object)redisKey);
            return (GoogleAuthenticatorToken)ops.get();
        }
        catch (NoResultException e) {
            LOGGER.debug("No record could be found for google authenticator id [{}]", (Object)uid);
            return null;
        }
    }

    public void removeAll() {
        try {
            Set<String> redisKey = this.getGoogleAuthenticatorTokenKeys();
            LOGGER.trace("Deleting tokens using key [{}]", redisKey);
            this.template.delete(redisKey);
            LOGGER.trace("Deleted tokens");
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    protected void cleanInternal() {
    }

    public void remove(String uid, Integer otp) {
        try {
            String redisKey = GoogleAuthenticatorRedisTokenRepository.getGoogleAuthenticatorTokenRedisKey(uid, otp);
            LOGGER.trace("Deleting token [{}] for [{}] using key [{}]", new Object[]{otp, uid, redisKey});
            this.template.delete((Object)redisKey);
            LOGGER.trace("Deleted token [{}]", (Object)redisKey);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void remove(String uid) {
        try {
            try {
                Set<String> redisKey = this.getGoogleAuthenticatorTokenKeys(uid);
                LOGGER.trace("Deleting tokens for [{}] using key [{}]", (Object)uid, redisKey);
                this.template.delete(redisKey);
                LOGGER.trace("Deleted tokens [{}]", redisKey);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void remove(Integer otp) {
        try {
            Set<String> redisKey = this.getGoogleAuthenticatorTokenKeys(otp);
            LOGGER.trace("Deleting token for [{}] using key [{}]", (Object)otp, redisKey);
            this.template.delete(redisKey);
            LOGGER.trace("Deleted tokens [{}]", redisKey);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    public long count(String uid) {
        try {
            Set<String> keys = this.getGoogleAuthenticatorTokenKeys(uid);
            return keys.size();
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public long count() {
        try {
            Set<String> keys = this.getGoogleAuthenticatorTokenKeys();
            return keys.size();
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    private static String getGoogleAuthenticatorTokenRedisKey(GoogleAuthenticatorToken token) {
        return GoogleAuthenticatorRedisTokenRepository.getGoogleAuthenticatorTokenRedisKey(token.getUserId(), token.getToken());
    }

    private static String getGoogleAuthenticatorTokenRedisKey(String username, Integer otp) {
        return CAS_PREFIX + KEY_SEPARATOR + username + KEY_SEPARATOR + otp;
    }

    private static String getGoogleAuthenticatorTokenRedisKey(String username) {
        return CAS_PREFIX + KEY_SEPARATOR + username + ":*";
    }

    private static String getGoogleAuthenticatorTokenRedisKey(Integer otp) {
        return CAS_PREFIX + ":*:" + otp;
    }

    private static String getPatternGoogleAuthenticatorTokenRedisKey() {
        return CAS_PREFIX + ":*";
    }

    private Set<String> getGoogleAuthenticatorTokenKeys() {
        String key = GoogleAuthenticatorRedisTokenRepository.getPatternGoogleAuthenticatorTokenRedisKey();
        LOGGER.trace("Fetching Google Authenticator records based on key [{}]", (Object)key);
        return this.template.keys((Object)key);
    }

    private Set<String> getGoogleAuthenticatorTokenKeys(String username) {
        String key = GoogleAuthenticatorRedisTokenRepository.getGoogleAuthenticatorTokenRedisKey(username);
        LOGGER.trace("Fetching Google Authenticator records based on key [{}] for [{}]", (Object)key, (Object)username);
        return this.template.keys((Object)key);
    }

    private Set<String> getGoogleAuthenticatorTokenKeys(Integer otp) {
        String key = GoogleAuthenticatorRedisTokenRepository.getGoogleAuthenticatorTokenRedisKey(otp);
        LOGGER.trace("Fetching Google Authenticator records based on key [{}] for [{}]", (Object)key, (Object)otp);
        return this.template.keys((Object)key);
    }

    @Generated
    public GoogleAuthenticatorRedisTokenRepository(RedisTemplate<String, GoogleAuthenticatorToken> template, long expireTokensInSeconds) {
        this.template = template;
        this.expireTokensInSeconds = expireTokensInSeconds;
    }
}

