/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.warrenstrange.googleauth.IGoogleAuthenticator;
import java.util.List;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.RedisGoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.configuration.model.support.redis.BaseRedisProperties;
import org.apereo.cas.gauth.credential.RedisGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.gauth.token.GoogleAuthenticatorRedisTokenRepository;
import org.apereo.cas.gauth.token.GoogleAuthenticatorToken;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.otp.repository.token.OneTimeTokenRepository;
import org.apereo.cas.redis.core.RedisObjectFactory;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration(value="googleAuthenticatorRedisConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement(proxyTargetClass=true)
@EnableScheduling
public class GoogleAuthenticatorRedisConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @RefreshScope
    @Bean
    public PersistenceExceptionTranslationPostProcessor persistenceExceptionTranslationPostProcessor() {
        return new PersistenceExceptionTranslationPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean(name={"redisGoogleAuthenticatorConnectionFactory"})
    public RedisConnectionFactory redisGoogleAuthenticatorConnectionFactory() {
        RedisGoogleAuthenticatorMultifactorProperties redis = this.casProperties.getAuthn().getMfa().getGauth().getRedis();
        return RedisObjectFactory.newRedisConnectionFactory((BaseRedisProperties)redis);
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"redisGoogleAuthenticatorTemplate"})
    public RedisTemplate redisGoogleAuthenticatorTemplate() {
        return RedisObjectFactory.newRedisTemplate((RedisConnectionFactory)this.redisGoogleAuthenticatorConnectionFactory());
    }

    @Autowired
    @Bean
    public OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry(@Qualifier(value="googleAuthenticatorInstance") IGoogleAuthenticator googleAuthenticatorInstance, @Qualifier(value="googleAuthenticatorAccountCipherExecutor") CipherExecutor googleAuthenticatorAccountCipherExecutor) {
        return new RedisGoogleAuthenticatorTokenCredentialRepository(googleAuthenticatorInstance, (RedisTemplate<String, List<? extends OneTimeTokenAccount>>)this.redisGoogleAuthenticatorTemplate(), (CipherExecutor<String, String>)googleAuthenticatorAccountCipherExecutor);
    }

    @Bean
    public OneTimeTokenRepository oneTimeTokenAuthenticatorTokenRepository() {
        return new GoogleAuthenticatorRedisTokenRepository((RedisTemplate<String, GoogleAuthenticatorToken>)this.redisGoogleAuthenticatorTemplate(), this.casProperties.getAuthn().getMfa().getGauth().getTimeStepSize());
    }
}

