/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import com.warrenstrange.googleauth.IGoogleAuthenticator;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.gauth.credential.BaseGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisGoogleAuthenticatorTokenCredentialRepository
extends BaseGoogleAuthenticatorTokenCredentialRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisGoogleAuthenticatorTokenCredentialRepository.class);
    private static final String KEY_SEPARATOR = ":";
    private static final String CAS_PREFIX = RedisGoogleAuthenticatorTokenCredentialRepository.class.getSimpleName();
    private final RedisTemplate<String, List<? extends OneTimeTokenAccount>> template;

    public RedisGoogleAuthenticatorTokenCredentialRepository(IGoogleAuthenticator googleAuthenticator, RedisTemplate<String, List<? extends OneTimeTokenAccount>> template, CipherExecutor<String, String> tokenCredentialCipher) {
        super(tokenCredentialCipher, googleAuthenticator);
        this.template = template;
    }

    public OneTimeTokenAccount get(String username, long id) {
        List r;
        Set<String> keys = this.getGoogleAuthenticatorTokenKeys(username, String.valueOf(id));
        if (keys != null && keys.size() == 1 && (r = (List)this.template.boundValueOps((Object)keys.iterator().next()).get()) != null && !r.isEmpty()) {
            return this.decode((OneTimeTokenAccount)r.get(0));
        }
        return null;
    }

    public OneTimeTokenAccount get(long id) {
        List r;
        Set<String> keys = this.getGoogleAuthenticatorTokenKeys("*", String.valueOf(id));
        if (keys != null && keys.size() == 1 && (r = (List)this.template.boundValueOps((Object)keys.iterator().next()).get()) != null && !r.isEmpty()) {
            return this.decode((OneTimeTokenAccount)r.get(0));
        }
        return null;
    }

    public Collection<? extends OneTimeTokenAccount> get(String username) {
        Set<String> keys = this.getGoogleAuthenticatorTokenKeys(username, "*");
        return keys.stream().map(key -> (List)this.template.boundValueOps(key).get()).filter(Objects::nonNull).map(arg_0 -> ((RedisGoogleAuthenticatorTokenCredentialRepository)this).decode(arg_0)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Collection<? extends OneTimeTokenAccount> load() {
        return this.getGoogleAuthenticatorTokenKeys().stream().map(redisKey -> (List)this.template.boundValueOps(redisKey).get()).filter(Objects::nonNull).map(arg_0 -> ((RedisGoogleAuthenticatorTokenCredentialRepository)this).decode(arg_0)).collect(Collectors.toList());
    }

    public OneTimeTokenAccount save(OneTimeTokenAccount account) {
        return this.update(account);
    }

    public OneTimeTokenAccount update(OneTimeTokenAccount account) {
        OneTimeTokenAccount encodedAccount = this.encode(account);
        String redisKey = RedisGoogleAuthenticatorTokenCredentialRepository.getGoogleAuthenticatorRedisKey(account);
        LOGGER.trace("Saving [{}] using key [{}]", (Object)encodedAccount, (Object)redisKey);
        BoundValueOperations ops = this.template.boundValueOps((Object)redisKey);
        ops.set((Object)CollectionUtils.wrapList((Object[])new OneTimeTokenAccount[]{encodedAccount}));
        return encodedAccount;
    }

    public void deleteAll() {
        Set<String> redisKey = this.getGoogleAuthenticatorTokenKeys();
        LOGGER.trace("Deleting tokens using key [{}]", redisKey);
        this.template.delete(redisKey);
        LOGGER.trace("Deleted tokens");
    }

    public void delete(String username) {
        Set<String> redisKey = this.getGoogleAuthenticatorTokenKeys(username, "*");
        LOGGER.trace("Deleting tokens using key [{}]", redisKey);
        this.template.delete(redisKey);
        LOGGER.trace("Deleted tokens");
    }

    public long count() {
        Set<String> keys = this.getGoogleAuthenticatorTokenKeys();
        return keys.size();
    }

    public long count(String username) {
        Set<String> keys = this.getGoogleAuthenticatorTokenKeys(username, "*");
        return keys.size();
    }

    private static String getGoogleAuthenticatorRedisKey(OneTimeTokenAccount account) {
        return CAS_PREFIX + KEY_SEPARATOR + account.getUsername().trim().toLowerCase() + KEY_SEPARATOR + account.getId();
    }

    private Set<String> getGoogleAuthenticatorTokenKeys(String username, String id) {
        String key = CAS_PREFIX + KEY_SEPARATOR + username.trim().toLowerCase() + KEY_SEPARATOR + id;
        LOGGER.trace("Fetching Google Authenticator records based on key [{}]", (Object)key);
        return this.template.keys((Object)key);
    }

    private Set<String> getGoogleAuthenticatorTokenKeys() {
        String key = CAS_PREFIX + ":*:*";
        LOGGER.trace("Fetching Google Authenticator records based on key [{}]", (Object)key);
        return this.template.keys((Object)key);
    }

    @Generated
    public String toString() {
        return "RedisGoogleAuthenticatorTokenCredentialRepository(template=" + this.template + ")";
    }

    @Generated
    public RedisTemplate<String, List<? extends OneTimeTokenAccount>> getTemplate() {
        return this.template;
    }
}

