/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.warrenstrange.googleauth.IGoogleAuthenticator;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.mfa.gauth.GoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.RedisGoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.configuration.model.support.redis.BaseRedisProperties;
import org.apereo.cas.gauth.credential.RedisGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.gauth.token.GoogleAuthenticatorRedisTokenRepository;
import org.apereo.cas.gauth.token.GoogleAuthenticatorToken;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.otp.repository.token.OneTimeTokenRepository;
import org.apereo.cas.redis.core.CasRedisTemplate;
import org.apereo.cas.redis.core.RedisObjectFactory;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.jooq.lambda.Unchecked;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement(proxyTargetClass=false)
@EnableScheduling
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.GoogleAuthenticator}, module="redis")
@AutoConfiguration
public class GoogleAuthenticatorRedisConfiguration {
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.mfa.gauth.redis.enabled").isTrue().evenIfMissing();

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public BeanPostProcessor persistenceExceptionTranslationPostProcessor() {
        return new PersistenceExceptionTranslationPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean(name={"redisGoogleAuthenticatorConnectionFactory"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public RedisConnectionFactory redisGoogleAuthenticatorConnectionFactory(ConfigurableApplicationContext applicationContext, @Qualifier(value="casSslContext") CasSSLContext casSslContext, CasConfigurationProperties casProperties) {
        return (RedisConnectionFactory)BeanSupplier.of(RedisConnectionFactory.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(Unchecked.supplier(() -> {
            RedisGoogleAuthenticatorMultifactorProperties redis = casProperties.getAuthn().getMfa().getGauth().getRedis();
            return RedisObjectFactory.newRedisConnectionFactory((BaseRedisProperties)redis, (CasSSLContext)casSslContext);
        })).otherwiseProxy().get();
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"redisAccountsGoogleAuthenticatorTemplate"})
    public CasRedisTemplate redisAccountsGoogleAuthenticatorTemplate(ConfigurableApplicationContext applicationContext, @Qualifier(value="redisGoogleAuthenticatorConnectionFactory") RedisConnectionFactory redisGoogleAuthenticatorConnectionFactory) {
        return (CasRedisTemplate)BeanSupplier.of(CasRedisTemplate.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> RedisObjectFactory.newRedisTemplate((RedisConnectionFactory)redisGoogleAuthenticatorConnectionFactory)).otherwiseProxy().get();
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"redisPrincipalsGoogleAuthenticatorTemplate"})
    public CasRedisTemplate redisPrincipalsGoogleAuthenticatorTemplate(ConfigurableApplicationContext applicationContext, @Qualifier(value="redisGoogleAuthenticatorConnectionFactory") RedisConnectionFactory redisGoogleAuthenticatorConnectionFactory) {
        return (CasRedisTemplate)BeanSupplier.of(CasRedisTemplate.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> RedisObjectFactory.newRedisTemplate((RedisConnectionFactory)redisGoogleAuthenticatorConnectionFactory)).otherwiseProxy().get();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry(ConfigurableApplicationContext applicationContext, @Qualifier(value="googleAuthenticatorInstance") IGoogleAuthenticator googleAuthenticatorInstance, @Qualifier(value="googleAuthenticatorAccountCipherExecutor") CipherExecutor googleAuthenticatorAccountCipherExecutor, @Qualifier(value="googleAuthenticatorScratchCodesCipherExecutor") CipherExecutor googleAuthenticatorScratchCodesCipherExecutor, @Qualifier(value="redisAccountsGoogleAuthenticatorTemplate") CasRedisTemplate redisAccountsGoogleAuthenticatorTemplate, @Qualifier(value="redisPrincipalsGoogleAuthenticatorTemplate") CasRedisTemplate redisPrincipalsGoogleAuthenticatorTemplate, CasConfigurationProperties casProperties) {
        return (OneTimeTokenCredentialRepository)BeanSupplier.of(OneTimeTokenCredentialRepository.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            RedisGoogleAuthenticatorTokenCredentialRepository.CasRedisTemplates redisTemplates = new RedisGoogleAuthenticatorTokenCredentialRepository.CasRedisTemplates((CasRedisTemplate<String, OneTimeTokenAccount>)redisAccountsGoogleAuthenticatorTemplate, (CasRedisTemplate<String, OneTimeTokenAccount>)redisPrincipalsGoogleAuthenticatorTemplate);
            return new RedisGoogleAuthenticatorTokenCredentialRepository(googleAuthenticatorInstance, redisTemplates, (CipherExecutor<String, String>)googleAuthenticatorAccountCipherExecutor, (CipherExecutor<Number, Number>)googleAuthenticatorScratchCodesCipherExecutor);
        }).otherwiseProxy().get();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public OneTimeTokenRepository oneTimeTokenAuthenticatorTokenRepository(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="redisAccountsGoogleAuthenticatorTemplate") CasRedisTemplate redisAccountsGoogleAuthenticatorTemplate) {
        return (OneTimeTokenRepository)BeanSupplier.of(OneTimeTokenRepository.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            GoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth();
            return new GoogleAuthenticatorRedisTokenRepository((CasRedisTemplate<String, GoogleAuthenticatorToken>)redisAccountsGoogleAuthenticatorTemplate, gauth.getCore().getTimeStepSize(), gauth.getRedis().getScanCount());
        }).otherwiseProxy().get();
    }
}

