/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth;

import java.util.Locale;
import lombok.Generated;
import org.apereo.cas.authentication.OneTimeTokenAccount;

public class RedisCompositeKey {
    private static final String CAS_PREFIX_TOKEN_ACCOUNT = "CAS_TOKEN_ACCOUNT";
    private static final String CAS_PREFIX_TOKEN_PRINCIPAL = "CAS_TOKEN_PRINCIPAL";
    private final String query;
    private final String prefix;

    public String toKeyPattern() {
        return String.format("%s:%s", this.prefix, this.query);
    }

    public static RedisCompositeKey forAccounts() {
        return ((RedisCompositeKeyBuilder)RedisCompositeKey.builder().prefix(CAS_PREFIX_TOKEN_ACCOUNT)).build();
    }

    public static RedisCompositeKey forPrincipals() {
        return ((RedisCompositeKeyBuilder)RedisCompositeKey.builder().prefix(CAS_PREFIX_TOKEN_PRINCIPAL)).build();
    }

    public RedisCompositeKey withPrincipal(OneTimeTokenAccount account) {
        return this.withPrincipal(account.getUsername());
    }

    public RedisCompositeKey withPrincipal(String account) {
        String username = account.trim().toLowerCase(Locale.ENGLISH);
        return RedisCompositeKey.forPrincipals().withQuery(username);
    }

    public RedisCompositeKey withAccount(OneTimeTokenAccount account) {
        return this.withAccount(account.getId());
    }

    public RedisCompositeKey withAccount(long account) {
        return RedisCompositeKey.forAccounts().withQuery(String.valueOf(account));
    }

    @Generated
    private static String $default$query() {
        return "*";
    }

    @Generated
    protected RedisCompositeKey(RedisCompositeKeyBuilder<?, ?> b) {
        this.query = b.query$set ? b.query$value : RedisCompositeKey.$default$query();
        this.prefix = b.prefix;
    }

    @Generated
    public static RedisCompositeKeyBuilder<?, ?> builder() {
        return new RedisCompositeKeyBuilderImpl();
    }

    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public RedisCompositeKey(String query, String prefix) {
        this.query = query;
        this.prefix = prefix;
    }

    @Generated
    public RedisCompositeKey withQuery(String query) {
        return this.query == query ? this : new RedisCompositeKey(query, this.prefix);
    }

    @Generated
    public RedisCompositeKey withPrefix(String prefix) {
        return this.prefix == prefix ? this : new RedisCompositeKey(this.query, prefix);
    }

    @Generated
    public static abstract class RedisCompositeKeyBuilder<C extends RedisCompositeKey, B extends RedisCompositeKeyBuilder<C, B>> {
        @Generated
        private boolean query$set;
        @Generated
        private String query$value;
        @Generated
        private String prefix;

        @Generated
        public B query(String query) {
            this.query$value = query;
            this.query$set = true;
            return this.self();
        }

        @Generated
        public B prefix(String prefix) {
            this.prefix = prefix;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "RedisCompositeKey.RedisCompositeKeyBuilder(query$value=" + this.query$value + ", prefix=" + this.prefix + ")";
        }
    }

    @Generated
    private static final class RedisCompositeKeyBuilderImpl
    extends RedisCompositeKeyBuilder<RedisCompositeKey, RedisCompositeKeyBuilderImpl> {
        @Generated
        private RedisCompositeKeyBuilderImpl() {
        }

        @Override
        @Generated
        protected RedisCompositeKeyBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RedisCompositeKey build() {
            return new RedisCompositeKey(this);
        }
    }
}

